package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ListPrincipalsForPortfolioResponse(
    principals: Option[Iterable[zio.aws.servicecatalog.model.Principal]] = None,
    nextPageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioResponse = {
    import ListPrincipalsForPortfolioResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioResponse
      .builder()
      .optionallyWith(
        principals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.principals)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListPrincipalsForPortfolioResponse.ReadOnly =
    zio.aws.servicecatalog.model.ListPrincipalsForPortfolioResponse
      .wrap(buildAwsValue())
}
object ListPrincipalsForPortfolioResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListPrincipalsForPortfolioResponse =
      zio.aws.servicecatalog.model.ListPrincipalsForPortfolioResponse(
        principals.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def principals
        : Option[List[zio.aws.servicecatalog.model.Principal.ReadOnly]]
    def nextPageToken: Option[PageToken]
    def getPrincipals: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.Principal.ReadOnly
    ]] = AwsError.unwrapOptionField("principals", principals)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioResponse
  ) extends zio.aws.servicecatalog.model.ListPrincipalsForPortfolioResponse.ReadOnly {
    override val principals
        : Option[List[zio.aws.servicecatalog.model.Principal.ReadOnly]] = scala
      .Option(impl.principals())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.Principal.wrap(item)
        }.toList
      )
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioResponse
  ): zio.aws.servicecatalog.model.ListPrincipalsForPortfolioResponse.ReadOnly =
    new Wrapper(impl)
}
