package zio.aws.servicecatalog.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  PageToken,
  PageSize,
  Id,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class ListLaunchPathsRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    productId: Id,
    pageSize: Option[PageSize] = None,
    pageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest = {
    import ListLaunchPathsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .productId(Id.unwrap(productId): java.lang.String)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ListLaunchPathsRequest.ReadOnly =
    zio.aws.servicecatalog.model.ListLaunchPathsRequest.wrap(buildAwsValue())
}
object ListLaunchPathsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ListLaunchPathsRequest =
      zio.aws.servicecatalog.model.ListLaunchPathsRequest(
        acceptLanguage.map(value => value),
        productId,
        pageSize.map(value => value),
        pageToken.map(value => value)
      )
    def acceptLanguage: Option[AcceptLanguage]
    def productId: Id
    def pageSize: Option[PageSize]
    def pageToken: Option[PageToken]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getProductId: ZIO[Any, Nothing, Id] = ZIO.succeed(productId)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest
  ) extends zio.aws.servicecatalog.model.ListLaunchPathsRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val productId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.productId())
    override val pageSize: Option[PageSize] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.servicecatalog.model.primitives.PageSize(value))
    override val pageToken: Option[PageToken] = scala
      .Option(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest
  ): zio.aws.servicecatalog.model.ListLaunchPathsRequest.ReadOnly = new Wrapper(
    impl
  )
}
