package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{PortfolioName, Id}
import scala.jdk.CollectionConverters._
final case class LaunchPathSummary(
    id: Option[Id] = None,
    constraintSummaries: Option[
      Iterable[zio.aws.servicecatalog.model.ConstraintSummary]
    ] = None,
    tags: Option[Iterable[zio.aws.servicecatalog.model.Tag]] = None,
    name: Option[PortfolioName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.LaunchPathSummary = {
    import LaunchPathSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.LaunchPathSummary
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        constraintSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.constraintSummaries)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        name.map(value => PortfolioName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.LaunchPathSummary.ReadOnly =
    zio.aws.servicecatalog.model.LaunchPathSummary.wrap(buildAwsValue())
}
object LaunchPathSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.LaunchPathSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.LaunchPathSummary =
      zio.aws.servicecatalog.model.LaunchPathSummary(
        id.map(value => value),
        constraintSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value)
      )
    def id: Option[Id]
    def constraintSummaries
        : Option[List[zio.aws.servicecatalog.model.ConstraintSummary.ReadOnly]]
    def tags: Option[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def name: Option[PortfolioName]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getConstraintSummaries: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ConstraintSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("constraintSummaries", constraintSummaries)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getName: ZIO[Any, AwsError, PortfolioName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.LaunchPathSummary
  ) extends zio.aws.servicecatalog.model.LaunchPathSummary.ReadOnly {
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val constraintSummaries: Option[
      List[zio.aws.servicecatalog.model.ConstraintSummary.ReadOnly]
    ] = scala
      .Option(impl.constraintSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ConstraintSummary.wrap(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.Tag.wrap(item)
          }.toList
        )
    override val name: Option[PortfolioName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.PortfolioName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.LaunchPathSummary
  ): zio.aws.servicecatalog.model.LaunchPathSummary.ReadOnly = new Wrapper(impl)
}
