package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExecuteProvisionedProductPlanResponse(
    recordDetail: Option[zio.aws.servicecatalog.model.RecordDetail] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductPlanResponse = {
    import ExecuteProvisionedProductPlanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductPlanResponse
      .builder()
      .optionallyWith(recordDetail.map(value => value.buildAwsValue()))(
        _.recordDetail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ExecuteProvisionedProductPlanResponse.ReadOnly =
    zio.aws.servicecatalog.model.ExecuteProvisionedProductPlanResponse
      .wrap(buildAwsValue())
}
object ExecuteProvisionedProductPlanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductPlanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ExecuteProvisionedProductPlanResponse =
      zio.aws.servicecatalog.model.ExecuteProvisionedProductPlanResponse(
        recordDetail.map(value => value.asEditable)
      )
    def recordDetail: Option[zio.aws.servicecatalog.model.RecordDetail.ReadOnly]
    def getRecordDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.RecordDetail.ReadOnly
    ] = AwsError.unwrapOptionField("recordDetail", recordDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductPlanResponse
  ) extends zio.aws.servicecatalog.model.ExecuteProvisionedProductPlanResponse.ReadOnly {
    override val recordDetail
        : Option[zio.aws.servicecatalog.model.RecordDetail.ReadOnly] = scala
      .Option(impl.recordDetail())
      .map(value => zio.aws.servicecatalog.model.RecordDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ExecuteProvisionedProductPlanResponse
  ): zio.aws.servicecatalog.model.ExecuteProvisionedProductPlanResponse.ReadOnly =
    new Wrapper(impl)
}
