package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{Id, AcceptLanguage}
import scala.jdk.CollectionConverters._
final case class DisassociateProductFromPortfolioRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    productId: Id,
    portfolioId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DisassociateProductFromPortfolioRequest = {
    import DisassociateProductFromPortfolioRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DisassociateProductFromPortfolioRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .productId(Id.unwrap(productId): java.lang.String)
      .portfolioId(Id.unwrap(portfolioId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DisassociateProductFromPortfolioRequest.ReadOnly =
    zio.aws.servicecatalog.model.DisassociateProductFromPortfolioRequest
      .wrap(buildAwsValue())
}
object DisassociateProductFromPortfolioRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DisassociateProductFromPortfolioRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DisassociateProductFromPortfolioRequest =
      zio.aws.servicecatalog.model.DisassociateProductFromPortfolioRequest(
        acceptLanguage.map(value => value),
        productId,
        portfolioId
      )
    def acceptLanguage: Option[AcceptLanguage]
    def productId: Id
    def portfolioId: Id
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getProductId: ZIO[Any, Nothing, Id] = ZIO.succeed(productId)
    def getPortfolioId: ZIO[Any, Nothing, Id] = ZIO.succeed(portfolioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DisassociateProductFromPortfolioRequest
  ) extends zio.aws.servicecatalog.model.DisassociateProductFromPortfolioRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val productId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.productId())
    override val portfolioId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.portfolioId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DisassociateProductFromPortfolioRequest
  ): zio.aws.servicecatalog.model.DisassociateProductFromPortfolioRequest.ReadOnly =
    new Wrapper(impl)
}
