package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeServiceActionExecutionParametersResponse(
    serviceActionParameters: Option[
      Iterable[zio.aws.servicecatalog.model.ExecutionParameter]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionExecutionParametersResponse = {
    import DescribeServiceActionExecutionParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionExecutionParametersResponse
      .builder()
      .optionallyWith(
        serviceActionParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceActionParameters)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeServiceActionExecutionParametersResponse.ReadOnly =
    zio.aws.servicecatalog.model.DescribeServiceActionExecutionParametersResponse
      .wrap(buildAwsValue())
}
object DescribeServiceActionExecutionParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionExecutionParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DescribeServiceActionExecutionParametersResponse =
      zio.aws.servicecatalog.model
        .DescribeServiceActionExecutionParametersResponse(
          serviceActionParameters.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def serviceActionParameters
        : Option[List[zio.aws.servicecatalog.model.ExecutionParameter.ReadOnly]]
    def getServiceActionParameters: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ExecutionParameter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "serviceActionParameters",
      serviceActionParameters
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionExecutionParametersResponse
  ) extends zio.aws.servicecatalog.model.DescribeServiceActionExecutionParametersResponse.ReadOnly {
    override val serviceActionParameters: Option[
      List[zio.aws.servicecatalog.model.ExecutionParameter.ReadOnly]
    ] = scala
      .Option(impl.serviceActionParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ExecutionParameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeServiceActionExecutionParametersResponse
  ): zio.aws.servicecatalog.model.DescribeServiceActionExecutionParametersResponse.ReadOnly =
    new Wrapper(impl)
}
