package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  ProvisioningArtifactName,
  Verbose,
  ProductViewName,
  Id
}
import scala.jdk.CollectionConverters._
final case class DescribeProvisioningArtifactRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    provisioningArtifactId: Option[Id] = None,
    productId: Option[Id] = None,
    provisioningArtifactName: Option[ProvisioningArtifactName] = None,
    productName: Option[ProductViewName] = None,
    verbose: Option[Verbose] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningArtifactRequest = {
    import DescribeProvisioningArtifactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningArtifactRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .optionallyWith(
        provisioningArtifactId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisioningArtifactId)
      .optionallyWith(
        productId.map(value => Id.unwrap(value): java.lang.String)
      )(_.productId)
      .optionallyWith(
        provisioningArtifactName.map(value =>
          ProvisioningArtifactName.unwrap(value): java.lang.String
        )
      )(_.provisioningArtifactName)
      .optionallyWith(
        productName.map(value =>
          ProductViewName.unwrap(value): java.lang.String
        )
      )(_.productName)
      .optionallyWith(
        verbose.map(value => Verbose.unwrap(value): java.lang.Boolean)
      )(_.verbose)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeProvisioningArtifactRequest.ReadOnly =
    zio.aws.servicecatalog.model.DescribeProvisioningArtifactRequest
      .wrap(buildAwsValue())
}
object DescribeProvisioningArtifactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningArtifactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DescribeProvisioningArtifactRequest =
      zio.aws.servicecatalog.model.DescribeProvisioningArtifactRequest(
        acceptLanguage.map(value => value),
        provisioningArtifactId.map(value => value),
        productId.map(value => value),
        provisioningArtifactName.map(value => value),
        productName.map(value => value),
        verbose.map(value => value)
      )
    def acceptLanguage: Option[AcceptLanguage]
    def provisioningArtifactId: Option[Id]
    def productId: Option[Id]
    def provisioningArtifactName: Option[ProvisioningArtifactName]
    def productName: Option[ProductViewName]
    def verbose: Option[Verbose]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getProvisioningArtifactId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("provisioningArtifactId", provisioningArtifactId)
    def getProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("productId", productId)
    def getProvisioningArtifactName
        : ZIO[Any, AwsError, ProvisioningArtifactName] = AwsError
      .unwrapOptionField("provisioningArtifactName", provisioningArtifactName)
    def getProductName: ZIO[Any, AwsError, ProductViewName] =
      AwsError.unwrapOptionField("productName", productName)
    def getVerbose: ZIO[Any, AwsError, Verbose] =
      AwsError.unwrapOptionField("verbose", verbose)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningArtifactRequest
  ) extends zio.aws.servicecatalog.model.DescribeProvisioningArtifactRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val provisioningArtifactId: Option[Id] = scala
      .Option(impl.provisioningArtifactId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val productId: Option[Id] = scala
      .Option(impl.productId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisioningArtifactName: Option[ProvisioningArtifactName] =
      scala
        .Option(impl.provisioningArtifactName())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisioningArtifactName(value)
        )
    override val productName: Option[ProductViewName] = scala
      .Option(impl.productName())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProductViewName(value)
      )
    override val verbose: Option[Verbose] = scala
      .Option(impl.verbose())
      .map(value => zio.aws.servicecatalog.model.primitives.Verbose(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProvisioningArtifactRequest
  ): zio.aws.servicecatalog.model.DescribeProvisioningArtifactRequest.ReadOnly =
    new Wrapper(impl)
}
