package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  ProvisionedProductName,
  Id,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class DescribeProvisionedProductRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    id: Option[Id] = None,
    name: Option[ProvisionedProductName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductRequest = {
    import DescribeProvisionedProductRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        name.map(value =>
          ProvisionedProductName.unwrap(value): java.lang.String
        )
      )(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeProvisionedProductRequest.ReadOnly =
    zio.aws.servicecatalog.model.DescribeProvisionedProductRequest
      .wrap(buildAwsValue())
}
object DescribeProvisionedProductRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DescribeProvisionedProductRequest =
      zio.aws.servicecatalog.model.DescribeProvisionedProductRequest(
        acceptLanguage.map(value => value),
        id.map(value => value),
        name.map(value => value)
      )
    def acceptLanguage: Option[AcceptLanguage]
    def id: Option[Id]
    def name: Option[ProvisionedProductName]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ProvisionedProductName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductRequest
  ) extends zio.aws.servicecatalog.model.DescribeProvisionedProductRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val name: Option[ProvisionedProductName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProvisionedProductName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProvisionedProductRequest
  ): zio.aws.servicecatalog.model.DescribeProvisionedProductRequest.ReadOnly =
    new Wrapper(impl)
}
