package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{StatusDetail, Id}
import scala.jdk.CollectionConverters._
final case class DescribeCopyProductStatusResponse(
    copyProductStatus: Option[zio.aws.servicecatalog.model.CopyProductStatus] =
      None,
    targetProductId: Option[Id] = None,
    statusDetail: Option[StatusDetail] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeCopyProductStatusResponse = {
    import DescribeCopyProductStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeCopyProductStatusResponse
      .builder()
      .optionallyWith(copyProductStatus.map(value => value.unwrap))(
        _.copyProductStatus
      )
      .optionallyWith(
        targetProductId.map(value => Id.unwrap(value): java.lang.String)
      )(_.targetProductId)
      .optionallyWith(
        statusDetail.map(value => StatusDetail.unwrap(value): java.lang.String)
      )(_.statusDetail)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeCopyProductStatusResponse.ReadOnly =
    zio.aws.servicecatalog.model.DescribeCopyProductStatusResponse
      .wrap(buildAwsValue())
}
object DescribeCopyProductStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeCopyProductStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DescribeCopyProductStatusResponse =
      zio.aws.servicecatalog.model.DescribeCopyProductStatusResponse(
        copyProductStatus.map(value => value),
        targetProductId.map(value => value),
        statusDetail.map(value => value)
      )
    def copyProductStatus
        : Option[zio.aws.servicecatalog.model.CopyProductStatus]
    def targetProductId: Option[Id]
    def statusDetail: Option[StatusDetail]
    def getCopyProductStatus
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.CopyProductStatus] =
      AwsError.unwrapOptionField("copyProductStatus", copyProductStatus)
    def getTargetProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("targetProductId", targetProductId)
    def getStatusDetail: ZIO[Any, AwsError, StatusDetail] =
      AwsError.unwrapOptionField("statusDetail", statusDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeCopyProductStatusResponse
  ) extends zio.aws.servicecatalog.model.DescribeCopyProductStatusResponse.ReadOnly {
    override val copyProductStatus
        : Option[zio.aws.servicecatalog.model.CopyProductStatus] = scala
      .Option(impl.copyProductStatus())
      .map(value => zio.aws.servicecatalog.model.CopyProductStatus.wrap(value))
    override val targetProductId: Option[Id] = scala
      .Option(impl.targetProductId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val statusDetail: Option[StatusDetail] = scala
      .Option(impl.statusDetail())
      .map(value => zio.aws.servicecatalog.model.primitives.StatusDetail(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeCopyProductStatusResponse
  ): zio.aws.servicecatalog.model.DescribeCopyProductStatusResponse.ReadOnly =
    new Wrapper(impl)
}
