package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{Id, AcceptLanguage}
import scala.jdk.CollectionConverters._
final case class DeleteProductRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    id: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DeleteProductRequest = {
    import DeleteProductRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DeleteProductRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .id(Id.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.DeleteProductRequest.ReadOnly =
    zio.aws.servicecatalog.model.DeleteProductRequest.wrap(buildAwsValue())
}
object DeleteProductRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DeleteProductRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.DeleteProductRequest =
      zio.aws.servicecatalog.model
        .DeleteProductRequest(acceptLanguage.map(value => value), id)
    def acceptLanguage: Option[AcceptLanguage]
    def id: Id
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DeleteProductRequest
  ) extends zio.aws.servicecatalog.model.DeleteProductRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val id: Id = zio.aws.servicecatalog.model.primitives.Id(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DeleteProductRequest
  ): zio.aws.servicecatalog.model.DeleteProductRequest.ReadOnly = new Wrapper(
    impl
  )
}
