package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  ProductViewShortDescription,
  SupportUrl,
  SupportDescription,
  ProductViewName,
  SupportEmail,
  IdempotencyToken,
  ProductViewOwner
}
import scala.jdk.CollectionConverters._
final case class CreateProductRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    name: ProductViewName,
    owner: ProductViewOwner,
    description: Option[ProductViewShortDescription] = None,
    distributor: Option[ProductViewOwner] = None,
    supportDescription: Option[SupportDescription] = None,
    supportEmail: Option[SupportEmail] = None,
    supportUrl: Option[SupportUrl] = None,
    productType: zio.aws.servicecatalog.model.ProductType,
    tags: Option[Iterable[zio.aws.servicecatalog.model.Tag]] = None,
    provisioningArtifactParameters: zio.aws.servicecatalog.model.ProvisioningArtifactProperties,
    idempotencyToken: IdempotencyToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.CreateProductRequest = {
    import CreateProductRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.CreateProductRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .name(ProductViewName.unwrap(name): java.lang.String)
      .owner(ProductViewOwner.unwrap(owner): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ProductViewShortDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        distributor.map(value =>
          ProductViewOwner.unwrap(value): java.lang.String
        )
      )(_.distributor)
      .optionallyWith(
        supportDescription.map(value =>
          SupportDescription.unwrap(value): java.lang.String
        )
      )(_.supportDescription)
      .optionallyWith(
        supportEmail.map(value => SupportEmail.unwrap(value): java.lang.String)
      )(_.supportEmail)
      .optionallyWith(
        supportUrl.map(value => SupportUrl.unwrap(value): java.lang.String)
      )(_.supportUrl)
      .productType(productType.unwrap)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .provisioningArtifactParameters(
        provisioningArtifactParameters.buildAwsValue()
      )
      .idempotencyToken(
        IdempotencyToken.unwrap(idempotencyToken): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.CreateProductRequest.ReadOnly =
    zio.aws.servicecatalog.model.CreateProductRequest.wrap(buildAwsValue())
}
object CreateProductRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.CreateProductRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.CreateProductRequest =
      zio.aws.servicecatalog.model.CreateProductRequest(
        acceptLanguage.map(value => value),
        name,
        owner,
        description.map(value => value),
        distributor.map(value => value),
        supportDescription.map(value => value),
        supportEmail.map(value => value),
        supportUrl.map(value => value),
        productType,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        provisioningArtifactParameters.asEditable,
        idempotencyToken
      )
    def acceptLanguage: Option[AcceptLanguage]
    def name: ProductViewName
    def owner: ProductViewOwner
    def description: Option[ProductViewShortDescription]
    def distributor: Option[ProductViewOwner]
    def supportDescription: Option[SupportDescription]
    def supportEmail: Option[SupportEmail]
    def supportUrl: Option[SupportUrl]
    def productType: zio.aws.servicecatalog.model.ProductType
    def tags: Option[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def provisioningArtifactParameters
        : zio.aws.servicecatalog.model.ProvisioningArtifactProperties.ReadOnly
    def idempotencyToken: IdempotencyToken
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getName: ZIO[Any, Nothing, ProductViewName] = ZIO.succeed(name)
    def getOwner: ZIO[Any, Nothing, ProductViewOwner] = ZIO.succeed(owner)
    def getDescription: ZIO[Any, AwsError, ProductViewShortDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDistributor: ZIO[Any, AwsError, ProductViewOwner] =
      AwsError.unwrapOptionField("distributor", distributor)
    def getSupportDescription: ZIO[Any, AwsError, SupportDescription] =
      AwsError.unwrapOptionField("supportDescription", supportDescription)
    def getSupportEmail: ZIO[Any, AwsError, SupportEmail] =
      AwsError.unwrapOptionField("supportEmail", supportEmail)
    def getSupportUrl: ZIO[Any, AwsError, SupportUrl] =
      AwsError.unwrapOptionField("supportUrl", supportUrl)
    def getProductType
        : ZIO[Any, Nothing, zio.aws.servicecatalog.model.ProductType] =
      ZIO.succeed(productType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getProvisioningArtifactParameters: ZIO[
      Any,
      Nothing,
      zio.aws.servicecatalog.model.ProvisioningArtifactProperties.ReadOnly
    ] = ZIO.succeed(provisioningArtifactParameters)
    def getIdempotencyToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateProductRequest
  ) extends zio.aws.servicecatalog.model.CreateProductRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val name: ProductViewName =
      zio.aws.servicecatalog.model.primitives.ProductViewName(impl.name())
    override val owner: ProductViewOwner =
      zio.aws.servicecatalog.model.primitives.ProductViewOwner(impl.owner())
    override val description: Option[ProductViewShortDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .ProductViewShortDescription(value)
      )
    override val distributor: Option[ProductViewOwner] = scala
      .Option(impl.distributor())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProductViewOwner(value)
      )
    override val supportDescription: Option[SupportDescription] = scala
      .Option(impl.supportDescription())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.SupportDescription(value)
      )
    override val supportEmail: Option[SupportEmail] = scala
      .Option(impl.supportEmail())
      .map(value => zio.aws.servicecatalog.model.primitives.SupportEmail(value))
    override val supportUrl: Option[SupportUrl] = scala
      .Option(impl.supportUrl())
      .map(value => zio.aws.servicecatalog.model.primitives.SupportUrl(value))
    override val productType: zio.aws.servicecatalog.model.ProductType =
      zio.aws.servicecatalog.model.ProductType.wrap(impl.productType())
    override val tags: Option[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.Tag.wrap(item)
          }.toList
        )
    override val provisioningArtifactParameters
        : zio.aws.servicecatalog.model.ProvisioningArtifactProperties.ReadOnly =
      zio.aws.servicecatalog.model.ProvisioningArtifactProperties
        .wrap(impl.provisioningArtifactParameters())
    override val idempotencyToken: IdempotencyToken =
      zio.aws.servicecatalog.model.primitives
        .IdempotencyToken(impl.idempotencyToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateProductRequest
  ): zio.aws.servicecatalog.model.CreateProductRequest.ReadOnly = new Wrapper(
    impl
  )
}
