package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreatePortfolioResponse(
    portfolioDetail: Option[zio.aws.servicecatalog.model.PortfolioDetail] =
      None,
    tags: Option[Iterable[zio.aws.servicecatalog.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioResponse = {
    import CreatePortfolioResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioResponse
      .builder()
      .optionallyWith(portfolioDetail.map(value => value.buildAwsValue()))(
        _.portfolioDetail
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.CreatePortfolioResponse.ReadOnly =
    zio.aws.servicecatalog.model.CreatePortfolioResponse.wrap(buildAwsValue())
}
object CreatePortfolioResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.CreatePortfolioResponse =
      zio.aws.servicecatalog.model.CreatePortfolioResponse(
        portfolioDetail.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def portfolioDetail
        : Option[zio.aws.servicecatalog.model.PortfolioDetail.ReadOnly]
    def tags: Option[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def getPortfolioDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.PortfolioDetail.ReadOnly
    ] = AwsError.unwrapOptionField("portfolioDetail", portfolioDetail)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioResponse
  ) extends zio.aws.servicecatalog.model.CreatePortfolioResponse.ReadOnly {
    override val portfolioDetail
        : Option[zio.aws.servicecatalog.model.PortfolioDetail.ReadOnly] = scala
      .Option(impl.portfolioDetail())
      .map(value => zio.aws.servicecatalog.model.PortfolioDetail.wrap(value))
    override val tags: Option[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreatePortfolioResponse
  ): zio.aws.servicecatalog.model.CreatePortfolioResponse.ReadOnly =
    new Wrapper(impl)
}
