package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.ConstraintParameters
import scala.jdk.CollectionConverters._
final case class CreateConstraintResponse(
    constraintDetail: Option[zio.aws.servicecatalog.model.ConstraintDetail] =
      None,
    constraintParameters: Option[ConstraintParameters] = None,
    status: Option[zio.aws.servicecatalog.model.Status] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.CreateConstraintResponse = {
    import CreateConstraintResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.CreateConstraintResponse
      .builder()
      .optionallyWith(constraintDetail.map(value => value.buildAwsValue()))(
        _.constraintDetail
      )
      .optionallyWith(
        constraintParameters.map(value =>
          ConstraintParameters.unwrap(value): java.lang.String
        )
      )(_.constraintParameters)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.CreateConstraintResponse.ReadOnly =
    zio.aws.servicecatalog.model.CreateConstraintResponse.wrap(buildAwsValue())
}
object CreateConstraintResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.CreateConstraintResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.CreateConstraintResponse =
      zio.aws.servicecatalog.model.CreateConstraintResponse(
        constraintDetail.map(value => value.asEditable),
        constraintParameters.map(value => value),
        status.map(value => value)
      )
    def constraintDetail
        : Option[zio.aws.servicecatalog.model.ConstraintDetail.ReadOnly]
    def constraintParameters: Option[ConstraintParameters]
    def status: Option[zio.aws.servicecatalog.model.Status]
    def getConstraintDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ConstraintDetail.ReadOnly
    ] = AwsError.unwrapOptionField("constraintDetail", constraintDetail)
    def getConstraintParameters: ZIO[Any, AwsError, ConstraintParameters] =
      AwsError.unwrapOptionField("constraintParameters", constraintParameters)
    def getStatus: ZIO[Any, AwsError, zio.aws.servicecatalog.model.Status] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateConstraintResponse
  ) extends zio.aws.servicecatalog.model.CreateConstraintResponse.ReadOnly {
    override val constraintDetail
        : Option[zio.aws.servicecatalog.model.ConstraintDetail.ReadOnly] = scala
      .Option(impl.constraintDetail())
      .map(value => zio.aws.servicecatalog.model.ConstraintDetail.wrap(value))
    override val constraintParameters: Option[ConstraintParameters] = scala
      .Option(impl.constraintParameters())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ConstraintParameters(value)
      )
    override val status: Option[zio.aws.servicecatalog.model.Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.servicecatalog.model.Status.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.CreateConstraintResponse
  ): zio.aws.servicecatalog.model.CreateConstraintResponse.ReadOnly =
    new Wrapper(impl)
}
