package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  AccountId,
  ConstraintDescription,
  ConstraintType,
  Id
}
import scala.jdk.CollectionConverters._
final case class ConstraintDetail(
    constraintId: Option[Id] = None,
    `type`: Option[ConstraintType] = None,
    description: Option[ConstraintDescription] = None,
    owner: Option[AccountId] = None,
    productId: Option[Id] = None,
    portfolioId: Option[Id] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ConstraintDetail = {
    import ConstraintDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ConstraintDetail
      .builder()
      .optionallyWith(
        constraintId.map(value => Id.unwrap(value): java.lang.String)
      )(_.constraintId)
      .optionallyWith(
        `type`.map(value => ConstraintType.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        description.map(value =>
          ConstraintDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        owner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        productId.map(value => Id.unwrap(value): java.lang.String)
      )(_.productId)
      .optionallyWith(
        portfolioId.map(value => Id.unwrap(value): java.lang.String)
      )(_.portfolioId)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ConstraintDetail.ReadOnly =
    zio.aws.servicecatalog.model.ConstraintDetail.wrap(buildAwsValue())
}
object ConstraintDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ConstraintDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ConstraintDetail =
      zio.aws.servicecatalog.model.ConstraintDetail(
        constraintId.map(value => value),
        `type`.map(value => value),
        description.map(value => value),
        owner.map(value => value),
        productId.map(value => value),
        portfolioId.map(value => value)
      )
    def constraintId: Option[Id]
    def `type`: Option[ConstraintType]
    def description: Option[ConstraintDescription]
    def owner: Option[AccountId]
    def productId: Option[Id]
    def portfolioId: Option[Id]
    def getConstraintId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("constraintId", constraintId)
    def getType: ZIO[Any, AwsError, ConstraintType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDescription: ZIO[Any, AwsError, ConstraintDescription] =
      AwsError.unwrapOptionField("description", description)
    def getOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("owner", owner)
    def getProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("productId", productId)
    def getPortfolioId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("portfolioId", portfolioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ConstraintDetail
  ) extends zio.aws.servicecatalog.model.ConstraintDetail.ReadOnly {
    override val constraintId: Option[Id] = scala
      .Option(impl.constraintId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val `type`: Option[ConstraintType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ConstraintType(value)
      )
    override val description: Option[ConstraintDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ConstraintDescription(value)
      )
    override val owner: Option[AccountId] = scala
      .Option(impl.owner())
      .map(value => zio.aws.servicecatalog.model.primitives.AccountId(value))
    override val productId: Option[Id] = scala
      .Option(impl.productId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val portfolioId: Option[Id] = scala
      .Option(impl.portfolioId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ConstraintDetail
  ): zio.aws.servicecatalog.model.ConstraintDetail.ReadOnly = new Wrapper(impl)
}
