package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.servicecatalog.model.primitives.{TagOptionId, ResourceId}
import scala.jdk.CollectionConverters._
final case class AssociateTagOptionWithResourceRequest(
    resourceId: ResourceId,
    tagOptionId: TagOptionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.AssociateTagOptionWithResourceRequest = {
    import AssociateTagOptionWithResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.AssociateTagOptionWithResourceRequest
      .builder()
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .tagOptionId(TagOptionId.unwrap(tagOptionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.AssociateTagOptionWithResourceRequest.ReadOnly =
    zio.aws.servicecatalog.model.AssociateTagOptionWithResourceRequest
      .wrap(buildAwsValue())
}
object AssociateTagOptionWithResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.AssociateTagOptionWithResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.AssociateTagOptionWithResourceRequest =
      zio.aws.servicecatalog.model
        .AssociateTagOptionWithResourceRequest(resourceId, tagOptionId)
    def resourceId: ResourceId
    def tagOptionId: TagOptionId
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getTagOptionId: ZIO[Any, Nothing, TagOptionId] =
      ZIO.succeed(tagOptionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.AssociateTagOptionWithResourceRequest
  ) extends zio.aws.servicecatalog.model.AssociateTagOptionWithResourceRequest.ReadOnly {
    override val resourceId: ResourceId =
      zio.aws.servicecatalog.model.primitives.ResourceId(impl.resourceId())
    override val tagOptionId: TagOptionId =
      zio.aws.servicecatalog.model.primitives.TagOptionId(impl.tagOptionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.AssociateTagOptionWithResourceRequest
  ): zio.aws.servicecatalog.model.AssociateTagOptionWithResourceRequest.ReadOnly =
    new Wrapper(impl)
}
