package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait AccessStatus {
  def unwrap: software.amazon.awssdk.services.servicecatalog.model.AccessStatus
}
object AccessStatus {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.AccessStatus
  ): zio.aws.servicecatalog.model.AccessStatus = value match {
    case software.amazon.awssdk.services.servicecatalog.model.AccessStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.AccessStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.servicecatalog.model.AccessStatus.UNDER_CHANGE =>
      val r = UNDER_CHANGE
      r
    case software.amazon.awssdk.services.servicecatalog.model.AccessStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.AccessStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.AccessStatus =
      software.amazon.awssdk.services.servicecatalog.model.AccessStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.servicecatalog.model.AccessStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.AccessStatus =
      software.amazon.awssdk.services.servicecatalog.model.AccessStatus.ENABLED
  }
  case object UNDER_CHANGE extends zio.aws.servicecatalog.model.AccessStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.AccessStatus =
      software.amazon.awssdk.services.servicecatalog.model.AccessStatus.UNDER_CHANGE
  }
  case object DISABLED extends zio.aws.servicecatalog.model.AccessStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.AccessStatus =
      software.amazon.awssdk.services.servicecatalog.model.AccessStatus.DISABLED
  }
}
