package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.AccessLevelFilterValue
import scala.jdk.CollectionConverters._
final case class AccessLevelFilter(
    key: Option[zio.aws.servicecatalog.model.AccessLevelFilterKey] = None,
    value: Option[AccessLevelFilterValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilter = {
    import AccessLevelFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilter
      .builder()
      .optionallyWith(key.map(value => value.unwrap))(_.key)
      .optionallyWith(
        value.map(value =>
          AccessLevelFilterValue.unwrap(value): java.lang.String
        )
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.AccessLevelFilter.ReadOnly =
    zio.aws.servicecatalog.model.AccessLevelFilter.wrap(buildAwsValue())
}
object AccessLevelFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.AccessLevelFilter =
      zio.aws.servicecatalog.model
        .AccessLevelFilter(key.map(value => value), value.map(value => value))
    def key: Option[zio.aws.servicecatalog.model.AccessLevelFilterKey]
    def value: Option[AccessLevelFilterValue]
    def getKey: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.AccessLevelFilterKey
    ] = AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, AccessLevelFilterValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilter
  ) extends zio.aws.servicecatalog.model.AccessLevelFilter.ReadOnly {
    override val key
        : Option[zio.aws.servicecatalog.model.AccessLevelFilterKey] = scala
      .Option(impl.key())
      .map(value =>
        zio.aws.servicecatalog.model.AccessLevelFilterKey.wrap(value)
      )
    override val value: Option[AccessLevelFilterValue] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AccessLevelFilterValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilter
  ): zio.aws.servicecatalog.model.AccessLevelFilter.ReadOnly = new Wrapper(impl)
}
