package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  IdempotencyToken,
  PropertyValue,
  Id,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class UpdateProvisionedProductPropertiesRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    provisionedProductId: Id,
    provisionedProductProperties: Map[
      zio.aws.servicecatalog.model.PropertyKey,
      PropertyValue
    ],
    idempotencyToken: IdempotencyToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesRequest = {
    import UpdateProvisionedProductPropertiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .provisionedProductId(Id.unwrap(provisionedProductId): java.lang.String)
      .provisionedProductPropertiesWithStrings(
        provisionedProductProperties
          .map({ case (key, value) =>
            key.unwrap.toString -> (PropertyValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .idempotencyToken(
        IdempotencyToken.unwrap(idempotencyToken): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesRequest.ReadOnly =
    zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesRequest
      .wrap(buildAwsValue())
}
object UpdateProvisionedProductPropertiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesRequest =
      zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesRequest(
        acceptLanguage.map(value => value),
        provisionedProductId,
        provisionedProductProperties,
        idempotencyToken
      )
    def acceptLanguage: Option[AcceptLanguage]
    def provisionedProductId: Id
    def provisionedProductProperties
        : Map[zio.aws.servicecatalog.model.PropertyKey, PropertyValue]
    def idempotencyToken: IdempotencyToken
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getProvisionedProductId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(provisionedProductId)
    def getProvisionedProductProperties: ZIO[Any, Nothing, Map[
      zio.aws.servicecatalog.model.PropertyKey,
      PropertyValue
    ]] = ZIO.succeed(provisionedProductProperties)
    def getIdempotencyToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesRequest
  ) extends zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val provisionedProductId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.provisionedProductId())
    override val provisionedProductProperties
        : Map[zio.aws.servicecatalog.model.PropertyKey, PropertyValue] = impl
      .provisionedProductProperties()
      .asScala
      .map({ case (key, value) =>
        zio.aws.servicecatalog.model.PropertyKey.wrap(
          key
        ) -> zio.aws.servicecatalog.model.primitives.PropertyValue(value)
      })
      .toMap
    override val idempotencyToken: IdempotencyToken =
      zio.aws.servicecatalog.model.primitives
        .IdempotencyToken(impl.idempotencyToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateProvisionedProductPropertiesRequest
  ): zio.aws.servicecatalog.model.UpdateProvisionedProductPropertiesRequest.ReadOnly =
    new Wrapper(impl)
}
