package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  ProductViewShortDescription,
  SupportUrl,
  SupportDescription,
  ProductViewName,
  SupportEmail,
  ProductViewOwner,
  Id,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class UpdateProductRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    id: Id,
    name: Option[ProductViewName] = None,
    owner: Option[ProductViewOwner] = None,
    description: Option[ProductViewShortDescription] = None,
    distributor: Option[ProductViewOwner] = None,
    supportDescription: Option[SupportDescription] = None,
    supportEmail: Option[SupportEmail] = None,
    supportUrl: Option[SupportUrl] = None,
    addTags: Option[Iterable[zio.aws.servicecatalog.model.Tag]] = None,
    removeTags: Option[Iterable[TagKey]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.UpdateProductRequest = {
    import UpdateProductRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.UpdateProductRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .id(Id.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => ProductViewName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        owner.map(value => ProductViewOwner.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        description.map(value =>
          ProductViewShortDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        distributor.map(value =>
          ProductViewOwner.unwrap(value): java.lang.String
        )
      )(_.distributor)
      .optionallyWith(
        supportDescription.map(value =>
          SupportDescription.unwrap(value): java.lang.String
        )
      )(_.supportDescription)
      .optionallyWith(
        supportEmail.map(value => SupportEmail.unwrap(value): java.lang.String)
      )(_.supportEmail)
      .optionallyWith(
        supportUrl.map(value => SupportUrl.unwrap(value): java.lang.String)
      )(_.supportUrl)
      .optionallyWith(
        addTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addTags)
      .optionallyWith(
        removeTags.map(value =>
          value.map { item =>
            TagKey.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.removeTags)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.UpdateProductRequest.ReadOnly =
    zio.aws.servicecatalog.model.UpdateProductRequest.wrap(buildAwsValue())
}
object UpdateProductRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.UpdateProductRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.UpdateProductRequest =
      zio.aws.servicecatalog.model.UpdateProductRequest(
        acceptLanguage.map(value => value),
        id,
        name.map(value => value),
        owner.map(value => value),
        description.map(value => value),
        distributor.map(value => value),
        supportDescription.map(value => value),
        supportEmail.map(value => value),
        supportUrl.map(value => value),
        addTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        removeTags.map(value => value)
      )
    def acceptLanguage: Option[AcceptLanguage]
    def id: Id
    def name: Option[ProductViewName]
    def owner: Option[ProductViewOwner]
    def description: Option[ProductViewShortDescription]
    def distributor: Option[ProductViewOwner]
    def supportDescription: Option[SupportDescription]
    def supportEmail: Option[SupportEmail]
    def supportUrl: Option[SupportUrl]
    def addTags: Option[List[zio.aws.servicecatalog.model.Tag.ReadOnly]]
    def removeTags: Option[List[TagKey]]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, ProductViewName] =
      AwsError.unwrapOptionField("name", name)
    def getOwner: ZIO[Any, AwsError, ProductViewOwner] =
      AwsError.unwrapOptionField("owner", owner)
    def getDescription: ZIO[Any, AwsError, ProductViewShortDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDistributor: ZIO[Any, AwsError, ProductViewOwner] =
      AwsError.unwrapOptionField("distributor", distributor)
    def getSupportDescription: ZIO[Any, AwsError, SupportDescription] =
      AwsError.unwrapOptionField("supportDescription", supportDescription)
    def getSupportEmail: ZIO[Any, AwsError, SupportEmail] =
      AwsError.unwrapOptionField("supportEmail", supportEmail)
    def getSupportUrl: ZIO[Any, AwsError, SupportUrl] =
      AwsError.unwrapOptionField("supportUrl", supportUrl)
    def getAddTags
        : ZIO[Any, AwsError, List[zio.aws.servicecatalog.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("addTags", addTags)
    def getRemoveTags: ZIO[Any, AwsError, List[TagKey]] =
      AwsError.unwrapOptionField("removeTags", removeTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateProductRequest
  ) extends zio.aws.servicecatalog.model.UpdateProductRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val id: Id = zio.aws.servicecatalog.model.primitives.Id(impl.id())
    override val name: Option[ProductViewName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProductViewName(value)
      )
    override val owner: Option[ProductViewOwner] = scala
      .Option(impl.owner())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProductViewOwner(value)
      )
    override val description: Option[ProductViewShortDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .ProductViewShortDescription(value)
      )
    override val distributor: Option[ProductViewOwner] = scala
      .Option(impl.distributor())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProductViewOwner(value)
      )
    override val supportDescription: Option[SupportDescription] = scala
      .Option(impl.supportDescription())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.SupportDescription(value)
      )
    override val supportEmail: Option[SupportEmail] = scala
      .Option(impl.supportEmail())
      .map(value => zio.aws.servicecatalog.model.primitives.SupportEmail(value))
    override val supportUrl: Option[SupportUrl] = scala
      .Option(impl.supportUrl())
      .map(value => zio.aws.servicecatalog.model.primitives.SupportUrl(value))
    override val addTags
        : Option[List[zio.aws.servicecatalog.model.Tag.ReadOnly]] = scala
      .Option(impl.addTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.Tag.wrap(item)
        }.toList
      )
    override val removeTags: Option[List[TagKey]] = scala
      .Option(impl.removeTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.primitives.TagKey(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateProductRequest
  ): zio.aws.servicecatalog.model.UpdateProductRequest.ReadOnly = new Wrapper(
    impl
  )
}
