package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  ConstraintParameters,
  ConstraintDescription,
  Id,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class UpdateConstraintRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    id: Id,
    description: Option[ConstraintDescription] = None,
    parameters: Option[ConstraintParameters] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.UpdateConstraintRequest = {
    import UpdateConstraintRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.UpdateConstraintRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .id(Id.unwrap(id): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ConstraintDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        parameters.map(value =>
          ConstraintParameters.unwrap(value): java.lang.String
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.UpdateConstraintRequest.ReadOnly =
    zio.aws.servicecatalog.model.UpdateConstraintRequest.wrap(buildAwsValue())
}
object UpdateConstraintRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.UpdateConstraintRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.UpdateConstraintRequest =
      zio.aws.servicecatalog.model.UpdateConstraintRequest(
        acceptLanguage.map(value => value),
        id,
        description.map(value => value),
        parameters.map(value => value)
      )
    def acceptLanguage: Option[AcceptLanguage]
    def id: Id
    def description: Option[ConstraintDescription]
    def parameters: Option[ConstraintParameters]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
    def getDescription: ZIO[Any, AwsError, ConstraintDescription] =
      AwsError.unwrapOptionField("description", description)
    def getParameters: ZIO[Any, AwsError, ConstraintParameters] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateConstraintRequest
  ) extends zio.aws.servicecatalog.model.UpdateConstraintRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val id: Id = zio.aws.servicecatalog.model.primitives.Id(impl.id())
    override val description: Option[ConstraintDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ConstraintDescription(value)
      )
    override val parameters: Option[ConstraintParameters] = scala
      .Option(impl.parameters())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ConstraintParameters(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.UpdateConstraintRequest
  ): zio.aws.servicecatalog.model.UpdateConstraintRequest.ReadOnly =
    new Wrapper(impl)
}
