package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.servicecatalog.model.primitives.{
  RoleArn,
  RecordType,
  ProvisionedProductType,
  ProvisionedProductName,
  UpdatedTime,
  CreatedTime,
  Id
}
import scala.jdk.CollectionConverters._
final case class RecordDetail(
    recordId: Option[Id] = None,
    provisionedProductName: Option[ProvisionedProductName] = None,
    status: Option[zio.aws.servicecatalog.model.RecordStatus] = None,
    createdTime: Option[CreatedTime] = None,
    updatedTime: Option[UpdatedTime] = None,
    provisionedProductType: Option[ProvisionedProductType] = None,
    recordType: Option[RecordType] = None,
    provisionedProductId: Option[Id] = None,
    productId: Option[Id] = None,
    provisioningArtifactId: Option[Id] = None,
    pathId: Option[Id] = None,
    recordErrors: Option[Iterable[zio.aws.servicecatalog.model.RecordError]] =
      None,
    recordTags: Option[Iterable[zio.aws.servicecatalog.model.RecordTag]] = None,
    launchRoleArn: Option[RoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.RecordDetail = {
    import RecordDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.RecordDetail
      .builder()
      .optionallyWith(
        recordId.map(value => Id.unwrap(value): java.lang.String)
      )(_.recordId)
      .optionallyWith(
        provisionedProductName.map(value =>
          ProvisionedProductName.unwrap(value): java.lang.String
        )
      )(_.provisionedProductName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        createdTime.map(value => CreatedTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        updatedTime.map(value => UpdatedTime.unwrap(value): Instant)
      )(_.updatedTime)
      .optionallyWith(
        provisionedProductType.map(value =>
          ProvisionedProductType.unwrap(value): java.lang.String
        )
      )(_.provisionedProductType)
      .optionallyWith(
        recordType.map(value => RecordType.unwrap(value): java.lang.String)
      )(_.recordType)
      .optionallyWith(
        provisionedProductId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisionedProductId)
      .optionallyWith(
        productId.map(value => Id.unwrap(value): java.lang.String)
      )(_.productId)
      .optionallyWith(
        provisioningArtifactId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisioningArtifactId)
      .optionallyWith(pathId.map(value => Id.unwrap(value): java.lang.String))(
        _.pathId
      )
      .optionallyWith(
        recordErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recordErrors)
      .optionallyWith(
        recordTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recordTags)
      .optionallyWith(
        launchRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.launchRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.RecordDetail.ReadOnly =
    zio.aws.servicecatalog.model.RecordDetail.wrap(buildAwsValue())
}
object RecordDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.RecordDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.RecordDetail =
      zio.aws.servicecatalog.model.RecordDetail(
        recordId.map(value => value),
        provisionedProductName.map(value => value),
        status.map(value => value),
        createdTime.map(value => value),
        updatedTime.map(value => value),
        provisionedProductType.map(value => value),
        recordType.map(value => value),
        provisionedProductId.map(value => value),
        productId.map(value => value),
        provisioningArtifactId.map(value => value),
        pathId.map(value => value),
        recordErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recordTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        launchRoleArn.map(value => value)
      )
    def recordId: Option[Id]
    def provisionedProductName: Option[ProvisionedProductName]
    def status: Option[zio.aws.servicecatalog.model.RecordStatus]
    def createdTime: Option[CreatedTime]
    def updatedTime: Option[UpdatedTime]
    def provisionedProductType: Option[ProvisionedProductType]
    def recordType: Option[RecordType]
    def provisionedProductId: Option[Id]
    def productId: Option[Id]
    def provisioningArtifactId: Option[Id]
    def pathId: Option[Id]
    def recordErrors
        : Option[List[zio.aws.servicecatalog.model.RecordError.ReadOnly]]
    def recordTags
        : Option[List[zio.aws.servicecatalog.model.RecordTag.ReadOnly]]
    def launchRoleArn: Option[RoleArn]
    def getRecordId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("recordId", recordId)
    def getProvisionedProductName: ZIO[Any, AwsError, ProvisionedProductName] =
      AwsError.unwrapOptionField(
        "provisionedProductName",
        provisionedProductName
      )
    def getStatus
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.RecordStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedTime: ZIO[Any, AwsError, CreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getUpdatedTime: ZIO[Any, AwsError, UpdatedTime] =
      AwsError.unwrapOptionField("updatedTime", updatedTime)
    def getProvisionedProductType: ZIO[Any, AwsError, ProvisionedProductType] =
      AwsError.unwrapOptionField(
        "provisionedProductType",
        provisionedProductType
      )
    def getRecordType: ZIO[Any, AwsError, RecordType] =
      AwsError.unwrapOptionField("recordType", recordType)
    def getProvisionedProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("provisionedProductId", provisionedProductId)
    def getProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("productId", productId)
    def getProvisioningArtifactId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("provisioningArtifactId", provisioningArtifactId)
    def getPathId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("pathId", pathId)
    def getRecordErrors: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.RecordError.ReadOnly
    ]] = AwsError.unwrapOptionField("recordErrors", recordErrors)
    def getRecordTags: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.RecordTag.ReadOnly
    ]] = AwsError.unwrapOptionField("recordTags", recordTags)
    def getLaunchRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("launchRoleArn", launchRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.RecordDetail
  ) extends zio.aws.servicecatalog.model.RecordDetail.ReadOnly {
    override val recordId: Option[Id] = scala
      .Option(impl.recordId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisionedProductName: Option[ProvisionedProductName] = scala
      .Option(impl.provisionedProductName())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProvisionedProductName(value)
      )
    override val status: Option[zio.aws.servicecatalog.model.RecordStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.servicecatalog.model.RecordStatus.wrap(value))
    override val createdTime: Option[CreatedTime] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.servicecatalog.model.primitives.CreatedTime(value))
    override val updatedTime: Option[UpdatedTime] = scala
      .Option(impl.updatedTime())
      .map(value => zio.aws.servicecatalog.model.primitives.UpdatedTime(value))
    override val provisionedProductType: Option[ProvisionedProductType] = scala
      .Option(impl.provisionedProductType())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProvisionedProductType(value)
      )
    override val recordType: Option[RecordType] = scala
      .Option(impl.recordType())
      .map(value => zio.aws.servicecatalog.model.primitives.RecordType(value))
    override val provisionedProductId: Option[Id] = scala
      .Option(impl.provisionedProductId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val productId: Option[Id] = scala
      .Option(impl.productId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisioningArtifactId: Option[Id] = scala
      .Option(impl.provisioningArtifactId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val pathId: Option[Id] = scala
      .Option(impl.pathId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val recordErrors
        : Option[List[zio.aws.servicecatalog.model.RecordError.ReadOnly]] =
      scala
        .Option(impl.recordErrors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.RecordError.wrap(item)
          }.toList
        )
    override val recordTags
        : Option[List[zio.aws.servicecatalog.model.RecordTag.ReadOnly]] = scala
      .Option(impl.recordTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.RecordTag.wrap(item)
        }.toList
      )
    override val launchRoleArn: Option[RoleArn] = scala
      .Option(impl.launchRoleArn())
      .map(value => zio.aws.servicecatalog.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.RecordDetail
  ): zio.aws.servicecatalog.model.RecordDetail.ReadOnly = new Wrapper(impl)
}
