package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.servicecatalog.model.primitives.{
  RoleArn,
  ProvisionedProductId,
  LastRequestId,
  ProvisionedProductType,
  IdempotencyToken,
  ProvisionedProductNameOrArn,
  CreatedTime,
  ProvisionedProductStatusMessage,
  Id
}
import scala.jdk.CollectionConverters._
final case class ProvisionedProductDetail(
    name: Option[ProvisionedProductNameOrArn] = None,
    arn: Option[ProvisionedProductNameOrArn] = None,
    `type`: Option[ProvisionedProductType] = None,
    id: Option[ProvisionedProductId] = None,
    status: Option[zio.aws.servicecatalog.model.ProvisionedProductStatus] =
      None,
    statusMessage: Option[ProvisionedProductStatusMessage] = None,
    createdTime: Option[CreatedTime] = None,
    idempotencyToken: Option[IdempotencyToken] = None,
    lastRecordId: Option[LastRequestId] = None,
    lastProvisioningRecordId: Option[Id] = None,
    lastSuccessfulProvisioningRecordId: Option[Id] = None,
    productId: Option[Id] = None,
    provisioningArtifactId: Option[Id] = None,
    launchRoleArn: Option[RoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductDetail = {
    import ProvisionedProductDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductDetail
      .builder()
      .optionallyWith(
        name.map(value =>
          ProvisionedProductNameOrArn.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        arn.map(value =>
          ProvisionedProductNameOrArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .optionallyWith(
        `type`.map(value =>
          ProvisionedProductType.unwrap(value): java.lang.String
        )
      )(_.`type`)
      .optionallyWith(
        id.map(value => ProvisionedProductId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          ProvisionedProductStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        createdTime.map(value => CreatedTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        idempotencyToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.idempotencyToken)
      .optionallyWith(
        lastRecordId.map(value => LastRequestId.unwrap(value): java.lang.String)
      )(_.lastRecordId)
      .optionallyWith(
        lastProvisioningRecordId.map(value =>
          Id.unwrap(value): java.lang.String
        )
      )(_.lastProvisioningRecordId)
      .optionallyWith(
        lastSuccessfulProvisioningRecordId.map(value =>
          Id.unwrap(value): java.lang.String
        )
      )(_.lastSuccessfulProvisioningRecordId)
      .optionallyWith(
        productId.map(value => Id.unwrap(value): java.lang.String)
      )(_.productId)
      .optionallyWith(
        provisioningArtifactId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisioningArtifactId)
      .optionallyWith(
        launchRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.launchRoleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ProvisionedProductDetail.ReadOnly =
    zio.aws.servicecatalog.model.ProvisionedProductDetail.wrap(buildAwsValue())
}
object ProvisionedProductDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProvisionedProductDetail =
      zio.aws.servicecatalog.model.ProvisionedProductDetail(
        name.map(value => value),
        arn.map(value => value),
        `type`.map(value => value),
        id.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        createdTime.map(value => value),
        idempotencyToken.map(value => value),
        lastRecordId.map(value => value),
        lastProvisioningRecordId.map(value => value),
        lastSuccessfulProvisioningRecordId.map(value => value),
        productId.map(value => value),
        provisioningArtifactId.map(value => value),
        launchRoleArn.map(value => value)
      )
    def name: Option[ProvisionedProductNameOrArn]
    def arn: Option[ProvisionedProductNameOrArn]
    def `type`: Option[ProvisionedProductType]
    def id: Option[ProvisionedProductId]
    def status: Option[zio.aws.servicecatalog.model.ProvisionedProductStatus]
    def statusMessage: Option[ProvisionedProductStatusMessage]
    def createdTime: Option[CreatedTime]
    def idempotencyToken: Option[IdempotencyToken]
    def lastRecordId: Option[LastRequestId]
    def lastProvisioningRecordId: Option[Id]
    def lastSuccessfulProvisioningRecordId: Option[Id]
    def productId: Option[Id]
    def provisioningArtifactId: Option[Id]
    def launchRoleArn: Option[RoleArn]
    def getName: ZIO[Any, AwsError, ProvisionedProductNameOrArn] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, ProvisionedProductNameOrArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getType: ZIO[Any, AwsError, ProvisionedProductType] =
      AwsError.unwrapOptionField("type", `type`)
    def getId: ZIO[Any, AwsError, ProvisionedProductId] =
      AwsError.unwrapOptionField("id", id)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisionedProductStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, ProvisionedProductStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreatedTime: ZIO[Any, AwsError, CreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getIdempotencyToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
    def getLastRecordId: ZIO[Any, AwsError, LastRequestId] =
      AwsError.unwrapOptionField("lastRecordId", lastRecordId)
    def getLastProvisioningRecordId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("lastProvisioningRecordId", lastProvisioningRecordId)
    def getLastSuccessfulProvisioningRecordId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField(
        "lastSuccessfulProvisioningRecordId",
        lastSuccessfulProvisioningRecordId
      )
    def getProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("productId", productId)
    def getProvisioningArtifactId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("provisioningArtifactId", provisioningArtifactId)
    def getLaunchRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("launchRoleArn", launchRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductDetail
  ) extends zio.aws.servicecatalog.model.ProvisionedProductDetail.ReadOnly {
    override val name: Option[ProvisionedProductNameOrArn] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .ProvisionedProductNameOrArn(value)
      )
    override val arn: Option[ProvisionedProductNameOrArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .ProvisionedProductNameOrArn(value)
      )
    override val `type`: Option[ProvisionedProductType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProvisionedProductType(value)
      )
    override val id: Option[ProvisionedProductId] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProvisionedProductId(value)
      )
    override val status
        : Option[zio.aws.servicecatalog.model.ProvisionedProductStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.servicecatalog.model.ProvisionedProductStatus.wrap(value)
      )
    override val statusMessage: Option[ProvisionedProductStatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .ProvisionedProductStatusMessage(value)
      )
    override val createdTime: Option[CreatedTime] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.servicecatalog.model.primitives.CreatedTime(value))
    override val idempotencyToken: Option[IdempotencyToken] = scala
      .Option(impl.idempotencyToken())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.IdempotencyToken(value)
      )
    override val lastRecordId: Option[LastRequestId] = scala
      .Option(impl.lastRecordId())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.LastRequestId(value)
      )
    override val lastProvisioningRecordId: Option[Id] = scala
      .Option(impl.lastProvisioningRecordId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val lastSuccessfulProvisioningRecordId: Option[Id] = scala
      .Option(impl.lastSuccessfulProvisioningRecordId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val productId: Option[Id] = scala
      .Option(impl.productId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val provisioningArtifactId: Option[Id] = scala
      .Option(impl.provisioningArtifactId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val launchRoleArn: Option[RoleArn] = scala
      .Option(impl.launchRoleArn())
      .map(value => zio.aws.servicecatalog.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductDetail
  ): zio.aws.servicecatalog.model.ProvisionedProductDetail.ReadOnly =
    new Wrapper(impl)
}
