package zio.aws.servicecatalog.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  PageToken,
  PageSize,
  ResourceType,
  TagOptionId
}
import scala.jdk.CollectionConverters._
final case class ListResourcesForTagOptionRequest(
    tagOptionId: TagOptionId,
    resourceType: Option[ResourceType] = None,
    pageSize: Option[PageSize] = None,
    pageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest = {
    import ListResourcesForTagOptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest
      .builder()
      .tagOptionId(TagOptionId.unwrap(tagOptionId): java.lang.String)
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListResourcesForTagOptionRequest.ReadOnly =
    zio.aws.servicecatalog.model.ListResourcesForTagOptionRequest
      .wrap(buildAwsValue())
}
object ListResourcesForTagOptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListResourcesForTagOptionRequest =
      zio.aws.servicecatalog.model.ListResourcesForTagOptionRequest(
        tagOptionId,
        resourceType.map(value => value),
        pageSize.map(value => value),
        pageToken.map(value => value)
      )
    def tagOptionId: TagOptionId
    def resourceType: Option[ResourceType]
    def pageSize: Option[PageSize]
    def pageToken: Option[PageToken]
    def getTagOptionId: ZIO[Any, Nothing, TagOptionId] =
      ZIO.succeed(tagOptionId)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest
  ) extends zio.aws.servicecatalog.model.ListResourcesForTagOptionRequest.ReadOnly {
    override val tagOptionId: TagOptionId =
      zio.aws.servicecatalog.model.primitives.TagOptionId(impl.tagOptionId())
    override val resourceType: Option[ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.servicecatalog.model.primitives.ResourceType(value))
    override val pageSize: Option[PageSize] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.servicecatalog.model.primitives.PageSize(value))
    override val pageToken: Option[PageToken] = scala
      .Option(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionRequest
  ): zio.aws.servicecatalog.model.ListResourcesForTagOptionRequest.ReadOnly =
    new Wrapper(impl)
}
