package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ListProvisioningArtifactsForServiceActionResponse(
    provisioningArtifactViews: Option[
      Iterable[zio.aws.servicecatalog.model.ProvisioningArtifactView]
    ] = None,
    nextPageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse = {
    import ListProvisioningArtifactsForServiceActionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse
      .builder()
      .optionallyWith(
        provisioningArtifactViews.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisioningArtifactViews)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse.ReadOnly =
    zio.aws.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse
      .wrap(buildAwsValue())
}
object ListProvisioningArtifactsForServiceActionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse =
      zio.aws.servicecatalog.model
        .ListProvisioningArtifactsForServiceActionResponse(
          provisioningArtifactViews.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextPageToken.map(value => value)
        )
    def provisioningArtifactViews: Option[
      List[zio.aws.servicecatalog.model.ProvisioningArtifactView.ReadOnly]
    ]
    def nextPageToken: Option[PageToken]
    def getProvisioningArtifactViews: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ProvisioningArtifactView.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "provisioningArtifactViews",
      provisioningArtifactViews
    )
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse
  ) extends zio.aws.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse.ReadOnly {
    override val provisioningArtifactViews: Option[
      List[zio.aws.servicecatalog.model.ProvisioningArtifactView.ReadOnly]
    ] = scala
      .Option(impl.provisioningArtifactViews())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ProvisioningArtifactView.wrap(item)
        }.toList
      )
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse
  ): zio.aws.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse.ReadOnly =
    new Wrapper(impl)
}
