package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ListOrganizationPortfolioAccessResponse(
    organizationNodes: Option[
      Iterable[zio.aws.servicecatalog.model.OrganizationNode]
    ] = None,
    nextPageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessResponse = {
    import ListOrganizationPortfolioAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessResponse
      .builder()
      .optionallyWith(
        organizationNodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.organizationNodes)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListOrganizationPortfolioAccessResponse.ReadOnly =
    zio.aws.servicecatalog.model.ListOrganizationPortfolioAccessResponse
      .wrap(buildAwsValue())
}
object ListOrganizationPortfolioAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListOrganizationPortfolioAccessResponse =
      zio.aws.servicecatalog.model.ListOrganizationPortfolioAccessResponse(
        organizationNodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def organizationNodes
        : Option[List[zio.aws.servicecatalog.model.OrganizationNode.ReadOnly]]
    def nextPageToken: Option[PageToken]
    def getOrganizationNodes: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.OrganizationNode.ReadOnly
    ]] = AwsError.unwrapOptionField("organizationNodes", organizationNodes)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessResponse
  ) extends zio.aws.servicecatalog.model.ListOrganizationPortfolioAccessResponse.ReadOnly {
    override val organizationNodes
        : Option[List[zio.aws.servicecatalog.model.OrganizationNode.ReadOnly]] =
      scala
        .Option(impl.organizationNodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.OrganizationNode.wrap(item)
          }.toList
        )
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListOrganizationPortfolioAccessResponse
  ): zio.aws.servicecatalog.model.ListOrganizationPortfolioAccessResponse.ReadOnly =
    new Wrapper(impl)
}
