package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{OrganizationNodeValue, Id}
import scala.jdk.CollectionConverters._
final case class DescribePortfolioShareStatusResponse(
    portfolioShareToken: Option[Id] = None,
    portfolioId: Option[Id] = None,
    organizationNodeValue: Option[OrganizationNodeValue] = None,
    status: Option[zio.aws.servicecatalog.model.ShareStatus] = None,
    shareDetails: Option[zio.aws.servicecatalog.model.ShareDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusResponse = {
    import DescribePortfolioShareStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusResponse
      .builder()
      .optionallyWith(
        portfolioShareToken.map(value => Id.unwrap(value): java.lang.String)
      )(_.portfolioShareToken)
      .optionallyWith(
        portfolioId.map(value => Id.unwrap(value): java.lang.String)
      )(_.portfolioId)
      .optionallyWith(
        organizationNodeValue.map(value =>
          OrganizationNodeValue.unwrap(value): java.lang.String
        )
      )(_.organizationNodeValue)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(shareDetails.map(value => value.buildAwsValue()))(
        _.shareDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribePortfolioShareStatusResponse.ReadOnly =
    zio.aws.servicecatalog.model.DescribePortfolioShareStatusResponse
      .wrap(buildAwsValue())
}
object DescribePortfolioShareStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DescribePortfolioShareStatusResponse =
      zio.aws.servicecatalog.model.DescribePortfolioShareStatusResponse(
        portfolioShareToken.map(value => value),
        portfolioId.map(value => value),
        organizationNodeValue.map(value => value),
        status.map(value => value),
        shareDetails.map(value => value.asEditable)
      )
    def portfolioShareToken: Option[Id]
    def portfolioId: Option[Id]
    def organizationNodeValue: Option[OrganizationNodeValue]
    def status: Option[zio.aws.servicecatalog.model.ShareStatus]
    def shareDetails: Option[zio.aws.servicecatalog.model.ShareDetails.ReadOnly]
    def getPortfolioShareToken: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("portfolioShareToken", portfolioShareToken)
    def getPortfolioId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("portfolioId", portfolioId)
    def getOrganizationNodeValue: ZIO[Any, AwsError, OrganizationNodeValue] =
      AwsError.unwrapOptionField("organizationNodeValue", organizationNodeValue)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.ShareStatus] =
      AwsError.unwrapOptionField("status", status)
    def getShareDetails: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ShareDetails.ReadOnly
    ] = AwsError.unwrapOptionField("shareDetails", shareDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusResponse
  ) extends zio.aws.servicecatalog.model.DescribePortfolioShareStatusResponse.ReadOnly {
    override val portfolioShareToken: Option[Id] = scala
      .Option(impl.portfolioShareToken())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val portfolioId: Option[Id] = scala
      .Option(impl.portfolioId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val organizationNodeValue: Option[OrganizationNodeValue] = scala
      .Option(impl.organizationNodeValue())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.OrganizationNodeValue(value)
      )
    override val status: Option[zio.aws.servicecatalog.model.ShareStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.servicecatalog.model.ShareStatus.wrap(value))
    override val shareDetails
        : Option[zio.aws.servicecatalog.model.ShareDetails.ReadOnly] = scala
      .Option(impl.shareDetails())
      .map(value => zio.aws.servicecatalog.model.ShareDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioShareStatusResponse
  ): zio.aws.servicecatalog.model.DescribePortfolioShareStatusResponse.ReadOnly =
    new Wrapper(impl)
}
