package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  TagOptionValue,
  Owner,
  TagOptionId,
  TagOptionKey,
  TagOptionActive
}
import scala.jdk.CollectionConverters._
final case class TagOptionDetail(
    key: Option[TagOptionKey] = None,
    value: Option[TagOptionValue] = None,
    active: Option[TagOptionActive] = None,
    id: Option[TagOptionId] = None,
    owner: Option[Owner] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.TagOptionDetail = {
    import TagOptionDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.TagOptionDetail
      .builder()
      .optionallyWith(
        key.map(value => TagOptionKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => TagOptionValue.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(
        active.map(value => TagOptionActive.unwrap(value): java.lang.Boolean)
      )(_.active)
      .optionallyWith(
        id.map(value => TagOptionId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        owner.map(value => Owner.unwrap(value): java.lang.String)
      )(_.owner)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly =
    zio.aws.servicecatalog.model.TagOptionDetail.wrap(buildAwsValue())
}
object TagOptionDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.TagOptionDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.TagOptionDetail =
      zio.aws.servicecatalog.model.TagOptionDetail(
        key.map(value => value),
        value.map(value => value),
        active.map(value => value),
        id.map(value => value),
        owner.map(value => value)
      )
    def key: Option[TagOptionKey]
    def value: Option[TagOptionValue]
    def active: Option[TagOptionActive]
    def id: Option[TagOptionId]
    def owner: Option[Owner]
    def getKey: ZIO[Any, AwsError, TagOptionKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, TagOptionValue] =
      AwsError.unwrapOptionField("value", value)
    def getActive: ZIO[Any, AwsError, TagOptionActive] =
      AwsError.unwrapOptionField("active", active)
    def getId: ZIO[Any, AwsError, TagOptionId] =
      AwsError.unwrapOptionField("id", id)
    def getOwner: ZIO[Any, AwsError, Owner] =
      AwsError.unwrapOptionField("owner", owner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.TagOptionDetail
  ) extends zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly {
    override val key: Option[TagOptionKey] = scala
      .Option(impl.key())
      .map(value => zio.aws.servicecatalog.model.primitives.TagOptionKey(value))
    override val value: Option[TagOptionValue] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.TagOptionValue(value)
      )
    override val active: Option[TagOptionActive] = scala
      .Option(impl.active())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.TagOptionActive(value)
      )
    override val id: Option[TagOptionId] = scala
      .Option(impl.id())
      .map(value => zio.aws.servicecatalog.model.primitives.TagOptionId(value))
    override val owner: Option[Owner] = scala
      .Option(impl.owner())
      .map(value => zio.aws.servicecatalog.model.primitives.Owner(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.TagOptionDetail
  ): zio.aws.servicecatalog.model.TagOptionDetail.ReadOnly = new Wrapper(impl)
}
