package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.servicecatalog.model.primitives.{
  ProvisioningArtifactActive,
  CreationTime,
  ProvisioningArtifactName,
  Id
}
import scala.jdk.CollectionConverters._
final case class ProvisioningArtifactDetail(
    id: Option[Id] = None,
    name: Option[ProvisioningArtifactName] = None,
    description: Option[ProvisioningArtifactName] = None,
    `type`: Option[zio.aws.servicecatalog.model.ProvisioningArtifactType] =
      None,
    createdTime: Option[CreationTime] = None,
    active: Option[ProvisioningArtifactActive] = None,
    guidance: Option[
      zio.aws.servicecatalog.model.ProvisioningArtifactGuidance
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactDetail = {
    import ProvisioningArtifactDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactDetail
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        name.map(value =>
          ProvisioningArtifactName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ProvisioningArtifactName.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        createdTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        active.map(value =>
          ProvisioningArtifactActive.unwrap(value): java.lang.Boolean
        )
      )(_.active)
      .optionallyWith(guidance.map(value => value.unwrap))(_.guidance)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ProvisioningArtifactDetail.ReadOnly =
    zio.aws.servicecatalog.model.ProvisioningArtifactDetail
      .wrap(buildAwsValue())
}
object ProvisioningArtifactDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProvisioningArtifactDetail =
      zio.aws.servicecatalog.model.ProvisioningArtifactDetail(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        `type`.map(value => value),
        createdTime.map(value => value),
        active.map(value => value),
        guidance.map(value => value)
      )
    def id: Option[Id]
    def name: Option[ProvisioningArtifactName]
    def description: Option[ProvisioningArtifactName]
    def `type`: Option[zio.aws.servicecatalog.model.ProvisioningArtifactType]
    def createdTime: Option[CreationTime]
    def active: Option[ProvisioningArtifactActive]
    def guidance
        : Option[zio.aws.servicecatalog.model.ProvisioningArtifactGuidance]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ProvisioningArtifactName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ProvisioningArtifactName] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisioningArtifactType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getCreatedTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getActive: ZIO[Any, AwsError, ProvisioningArtifactActive] =
      AwsError.unwrapOptionField("active", active)
    def getGuidance: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.ProvisioningArtifactGuidance
    ] = AwsError.unwrapOptionField("guidance", guidance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactDetail
  ) extends zio.aws.servicecatalog.model.ProvisioningArtifactDetail.ReadOnly {
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val name: Option[ProvisioningArtifactName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProvisioningArtifactName(value)
      )
    override val description: Option[ProvisioningArtifactName] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProvisioningArtifactName(value)
      )
    override val `type`
        : Option[zio.aws.servicecatalog.model.ProvisioningArtifactType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.servicecatalog.model.ProvisioningArtifactType.wrap(value)
      )
    override val createdTime: Option[CreationTime] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.servicecatalog.model.primitives.CreationTime(value))
    override val active: Option[ProvisioningArtifactActive] = scala
      .Option(impl.active())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .ProvisioningArtifactActive(value)
      )
    override val guidance
        : Option[zio.aws.servicecatalog.model.ProvisioningArtifactGuidance] =
      scala
        .Option(impl.guidance())
        .map(value =>
          zio.aws.servicecatalog.model.ProvisioningArtifactGuidance.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactDetail
  ): zio.aws.servicecatalog.model.ProvisioningArtifactDetail.ReadOnly =
    new Wrapper(impl)
}
