package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  ProductViewShortDescription,
  SupportUrl,
  SupportDescription,
  ProductViewName,
  SupportEmail,
  ProductViewOwner,
  HasDefaultPath,
  ProductViewDistributor,
  Id
}
import scala.jdk.CollectionConverters._
final case class ProductViewSummary(
    id: Option[Id] = None,
    productId: Option[Id] = None,
    name: Option[ProductViewName] = None,
    owner: Option[ProductViewOwner] = None,
    shortDescription: Option[ProductViewShortDescription] = None,
    `type`: Option[zio.aws.servicecatalog.model.ProductType] = None,
    distributor: Option[ProductViewDistributor] = None,
    hasDefaultPath: Option[HasDefaultPath] = None,
    supportEmail: Option[SupportEmail] = None,
    supportDescription: Option[SupportDescription] = None,
    supportUrl: Option[SupportUrl] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProductViewSummary = {
    import ProductViewSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProductViewSummary
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        productId.map(value => Id.unwrap(value): java.lang.String)
      )(_.productId)
      .optionallyWith(
        name.map(value => ProductViewName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        owner.map(value => ProductViewOwner.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        shortDescription.map(value =>
          ProductViewShortDescription.unwrap(value): java.lang.String
        )
      )(_.shortDescription)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        distributor.map(value =>
          ProductViewDistributor.unwrap(value): java.lang.String
        )
      )(_.distributor)
      .optionallyWith(
        hasDefaultPath.map(value =>
          HasDefaultPath.unwrap(value): java.lang.Boolean
        )
      )(_.hasDefaultPath)
      .optionallyWith(
        supportEmail.map(value => SupportEmail.unwrap(value): java.lang.String)
      )(_.supportEmail)
      .optionallyWith(
        supportDescription.map(value =>
          SupportDescription.unwrap(value): java.lang.String
        )
      )(_.supportDescription)
      .optionallyWith(
        supportUrl.map(value => SupportUrl.unwrap(value): java.lang.String)
      )(_.supportUrl)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly =
    zio.aws.servicecatalog.model.ProductViewSummary.wrap(buildAwsValue())
}
object ProductViewSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProductViewSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProductViewSummary =
      zio.aws.servicecatalog.model.ProductViewSummary(
        id.map(value => value),
        productId.map(value => value),
        name.map(value => value),
        owner.map(value => value),
        shortDescription.map(value => value),
        `type`.map(value => value),
        distributor.map(value => value),
        hasDefaultPath.map(value => value),
        supportEmail.map(value => value),
        supportDescription.map(value => value),
        supportUrl.map(value => value)
      )
    def id: Option[Id]
    def productId: Option[Id]
    def name: Option[ProductViewName]
    def owner: Option[ProductViewOwner]
    def shortDescription: Option[ProductViewShortDescription]
    def `type`: Option[zio.aws.servicecatalog.model.ProductType]
    def distributor: Option[ProductViewDistributor]
    def hasDefaultPath: Option[HasDefaultPath]
    def supportEmail: Option[SupportEmail]
    def supportDescription: Option[SupportDescription]
    def supportUrl: Option[SupportUrl]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("productId", productId)
    def getName: ZIO[Any, AwsError, ProductViewName] =
      AwsError.unwrapOptionField("name", name)
    def getOwner: ZIO[Any, AwsError, ProductViewOwner] =
      AwsError.unwrapOptionField("owner", owner)
    def getShortDescription: ZIO[Any, AwsError, ProductViewShortDescription] =
      AwsError.unwrapOptionField("shortDescription", shortDescription)
    def getType: ZIO[Any, AwsError, zio.aws.servicecatalog.model.ProductType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDistributor: ZIO[Any, AwsError, ProductViewDistributor] =
      AwsError.unwrapOptionField("distributor", distributor)
    def getHasDefaultPath: ZIO[Any, AwsError, HasDefaultPath] =
      AwsError.unwrapOptionField("hasDefaultPath", hasDefaultPath)
    def getSupportEmail: ZIO[Any, AwsError, SupportEmail] =
      AwsError.unwrapOptionField("supportEmail", supportEmail)
    def getSupportDescription: ZIO[Any, AwsError, SupportDescription] =
      AwsError.unwrapOptionField("supportDescription", supportDescription)
    def getSupportUrl: ZIO[Any, AwsError, SupportUrl] =
      AwsError.unwrapOptionField("supportUrl", supportUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProductViewSummary
  ) extends zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly {
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val productId: Option[Id] = scala
      .Option(impl.productId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val name: Option[ProductViewName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProductViewName(value)
      )
    override val owner: Option[ProductViewOwner] = scala
      .Option(impl.owner())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProductViewOwner(value)
      )
    override val shortDescription: Option[ProductViewShortDescription] = scala
      .Option(impl.shortDescription())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .ProductViewShortDescription(value)
      )
    override val `type`: Option[zio.aws.servicecatalog.model.ProductType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.servicecatalog.model.ProductType.wrap(value))
    override val distributor: Option[ProductViewDistributor] = scala
      .Option(impl.distributor())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ProductViewDistributor(value)
      )
    override val hasDefaultPath: Option[HasDefaultPath] = scala
      .Option(impl.hasDefaultPath())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.HasDefaultPath(value)
      )
    override val supportEmail: Option[SupportEmail] = scala
      .Option(impl.supportEmail())
      .map(value => zio.aws.servicecatalog.model.primitives.SupportEmail(value))
    override val supportDescription: Option[SupportDescription] = scala
      .Option(impl.supportDescription())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.SupportDescription(value)
      )
    override val supportUrl: Option[SupportUrl] = scala
      .Option(impl.supportUrl())
      .map(value => zio.aws.servicecatalog.model.primitives.SupportUrl(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProductViewSummary
  ): zio.aws.servicecatalog.model.ProductViewSummary.ReadOnly = new Wrapper(
    impl
  )
}
