package zio.aws.servicecatalog.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  ApproximateCount,
  AttributeValue
}
import scala.jdk.CollectionConverters._
final case class ProductViewAggregationValue(
    value: Option[AttributeValue] = None,
    approximateCount: Option[ApproximateCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProductViewAggregationValue = {
    import ProductViewAggregationValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProductViewAggregationValue
      .builder()
      .optionallyWith(
        value.map(value => AttributeValue.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(
        approximateCount.map(value => ApproximateCount.unwrap(value): Integer)
      )(_.approximateCount)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ProductViewAggregationValue.ReadOnly =
    zio.aws.servicecatalog.model.ProductViewAggregationValue
      .wrap(buildAwsValue())
}
object ProductViewAggregationValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProductViewAggregationValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProductViewAggregationValue =
      zio.aws.servicecatalog.model.ProductViewAggregationValue(
        value.map(value => value),
        approximateCount.map(value => value)
      )
    def value: Option[AttributeValue]
    def approximateCount: Option[ApproximateCount]
    def getValue: ZIO[Any, AwsError, AttributeValue] =
      AwsError.unwrapOptionField("value", value)
    def getApproximateCount: ZIO[Any, AwsError, ApproximateCount] =
      AwsError.unwrapOptionField("approximateCount", approximateCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProductViewAggregationValue
  ) extends zio.aws.servicecatalog.model.ProductViewAggregationValue.ReadOnly {
    override val value: Option[AttributeValue] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AttributeValue(value)
      )
    override val approximateCount: Option[ApproximateCount] = scala
      .Option(impl.approximateCount())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.ApproximateCount(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProductViewAggregationValue
  ): zio.aws.servicecatalog.model.ProductViewAggregationValue.ReadOnly =
    new Wrapper(impl)
}
