package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.servicecatalog.model.primitives.{
  CreationTime,
  ProviderName,
  ResourceARN,
  PortfolioDisplayName,
  Id,
  PortfolioDescription
}
import scala.jdk.CollectionConverters._
final case class PortfolioDetail(
    id: Option[Id] = None,
    arn: Option[ResourceARN] = None,
    displayName: Option[PortfolioDisplayName] = None,
    description: Option[PortfolioDescription] = None,
    createdTime: Option[CreationTime] = None,
    providerName: Option[ProviderName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.PortfolioDetail = {
    import PortfolioDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.PortfolioDetail
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        arn.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        displayName.map(value =>
          PortfolioDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        description.map(value =>
          PortfolioDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        createdTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        providerName.map(value => ProviderName.unwrap(value): java.lang.String)
      )(_.providerName)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.PortfolioDetail.ReadOnly =
    zio.aws.servicecatalog.model.PortfolioDetail.wrap(buildAwsValue())
}
object PortfolioDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.PortfolioDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.PortfolioDetail =
      zio.aws.servicecatalog.model.PortfolioDetail(
        id.map(value => value),
        arn.map(value => value),
        displayName.map(value => value),
        description.map(value => value),
        createdTime.map(value => value),
        providerName.map(value => value)
      )
    def id: Option[Id]
    def arn: Option[ResourceARN]
    def displayName: Option[PortfolioDisplayName]
    def description: Option[PortfolioDescription]
    def createdTime: Option[CreationTime]
    def providerName: Option[ProviderName]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("arn", arn)
    def getDisplayName: ZIO[Any, AwsError, PortfolioDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, PortfolioDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getProviderName: ZIO[Any, AwsError, ProviderName] =
      AwsError.unwrapOptionField("providerName", providerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.PortfolioDetail
  ) extends zio.aws.servicecatalog.model.PortfolioDetail.ReadOnly {
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val arn: Option[ResourceARN] = scala
      .Option(impl.arn())
      .map(value => zio.aws.servicecatalog.model.primitives.ResourceARN(value))
    override val displayName: Option[PortfolioDisplayName] = scala
      .Option(impl.displayName())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.PortfolioDisplayName(value)
      )
    override val description: Option[PortfolioDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.PortfolioDescription(value)
      )
    override val createdTime: Option[CreationTime] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.servicecatalog.model.primitives.CreationTime(value))
    override val providerName: Option[ProviderName] = scala
      .Option(impl.providerName())
      .map(value => zio.aws.servicecatalog.model.primitives.ProviderName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.PortfolioDetail
  ): zio.aws.servicecatalog.model.PortfolioDetail.ReadOnly = new Wrapper(impl)
}
