package zio.aws.servicecatalog.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  PageToken,
  PageSize,
  Id,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class ListPrincipalsForPortfolioRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    portfolioId: Id,
    pageSize: Option[PageSize] = None,
    pageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest = {
    import ListPrincipalsForPortfolioRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .portfolioId(Id.unwrap(portfolioId): java.lang.String)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListPrincipalsForPortfolioRequest.ReadOnly =
    zio.aws.servicecatalog.model.ListPrincipalsForPortfolioRequest
      .wrap(buildAwsValue())
}
object ListPrincipalsForPortfolioRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListPrincipalsForPortfolioRequest =
      zio.aws.servicecatalog.model.ListPrincipalsForPortfolioRequest(
        acceptLanguage.map(value => value),
        portfolioId,
        pageSize.map(value => value),
        pageToken.map(value => value)
      )
    def acceptLanguage: Option[AcceptLanguage]
    def portfolioId: Id
    def pageSize: Option[PageSize]
    def pageToken: Option[PageToken]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getPortfolioId: ZIO[Any, Nothing, Id] = ZIO.succeed(portfolioId)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest
  ) extends zio.aws.servicecatalog.model.ListPrincipalsForPortfolioRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val portfolioId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.portfolioId())
    override val pageSize: Option[PageSize] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.servicecatalog.model.primitives.PageSize(value))
    override val pageToken: Option[PageToken] = scala
      .Option(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListPrincipalsForPortfolioRequest
  ): zio.aws.servicecatalog.model.ListPrincipalsForPortfolioRequest.ReadOnly =
    new Wrapper(impl)
}
