package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  PhysicalId,
  ProvisionedProductName,
  IdempotencyToken,
  Id
}
import scala.jdk.CollectionConverters._
final case class ImportAsProvisionedProductRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    productId: Id,
    provisioningArtifactId: Id,
    provisionedProductName: ProvisionedProductName,
    physicalId: PhysicalId,
    idempotencyToken: IdempotencyToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ImportAsProvisionedProductRequest = {
    import ImportAsProvisionedProductRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ImportAsProvisionedProductRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .productId(Id.unwrap(productId): java.lang.String)
      .provisioningArtifactId(
        Id.unwrap(provisioningArtifactId): java.lang.String
      )
      .provisionedProductName(
        ProvisionedProductName.unwrap(provisionedProductName): java.lang.String
      )
      .physicalId(PhysicalId.unwrap(physicalId): java.lang.String)
      .idempotencyToken(
        IdempotencyToken.unwrap(idempotencyToken): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ImportAsProvisionedProductRequest.ReadOnly =
    zio.aws.servicecatalog.model.ImportAsProvisionedProductRequest
      .wrap(buildAwsValue())
}
object ImportAsProvisionedProductRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ImportAsProvisionedProductRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ImportAsProvisionedProductRequest =
      zio.aws.servicecatalog.model.ImportAsProvisionedProductRequest(
        acceptLanguage.map(value => value),
        productId,
        provisioningArtifactId,
        provisionedProductName,
        physicalId,
        idempotencyToken
      )
    def acceptLanguage: Option[AcceptLanguage]
    def productId: Id
    def provisioningArtifactId: Id
    def provisionedProductName: ProvisionedProductName
    def physicalId: PhysicalId
    def idempotencyToken: IdempotencyToken
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getProductId: ZIO[Any, Nothing, Id] = ZIO.succeed(productId)
    def getProvisioningArtifactId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(provisioningArtifactId)
    def getProvisionedProductName: ZIO[Any, Nothing, ProvisionedProductName] =
      ZIO.succeed(provisionedProductName)
    def getPhysicalId: ZIO[Any, Nothing, PhysicalId] = ZIO.succeed(physicalId)
    def getIdempotencyToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ImportAsProvisionedProductRequest
  ) extends zio.aws.servicecatalog.model.ImportAsProvisionedProductRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val productId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.productId())
    override val provisioningArtifactId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.provisioningArtifactId())
    override val provisionedProductName: ProvisionedProductName =
      zio.aws.servicecatalog.model.primitives
        .ProvisionedProductName(impl.provisionedProductName())
    override val physicalId: PhysicalId =
      zio.aws.servicecatalog.model.primitives.PhysicalId(impl.physicalId())
    override val idempotencyToken: IdempotencyToken =
      zio.aws.servicecatalog.model.primitives
        .IdempotencyToken(impl.idempotencyToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ImportAsProvisionedProductRequest
  ): zio.aws.servicecatalog.model.ImportAsProvisionedProductRequest.ReadOnly =
    new Wrapper(impl)
}
