package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetAwsOrganizationsAccessStatusResponse(
    accessStatus: Option[zio.aws.servicecatalog.model.AccessStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.GetAwsOrganizationsAccessStatusResponse = {
    import GetAwsOrganizationsAccessStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.GetAwsOrganizationsAccessStatusResponse
      .builder()
      .optionallyWith(accessStatus.map(value => value.unwrap))(_.accessStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.GetAwsOrganizationsAccessStatusResponse.ReadOnly =
    zio.aws.servicecatalog.model.GetAwsOrganizationsAccessStatusResponse
      .wrap(buildAwsValue())
}
object GetAwsOrganizationsAccessStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.GetAwsOrganizationsAccessStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.GetAwsOrganizationsAccessStatusResponse =
      zio.aws.servicecatalog.model.GetAwsOrganizationsAccessStatusResponse(
        accessStatus.map(value => value)
      )
    def accessStatus: Option[zio.aws.servicecatalog.model.AccessStatus]
    def getAccessStatus
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.AccessStatus] =
      AwsError.unwrapOptionField("accessStatus", accessStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.GetAwsOrganizationsAccessStatusResponse
  ) extends zio.aws.servicecatalog.model.GetAwsOrganizationsAccessStatusResponse.ReadOnly {
    override val accessStatus
        : Option[zio.aws.servicecatalog.model.AccessStatus] = scala
      .Option(impl.accessStatus())
      .map(value => zio.aws.servicecatalog.model.AccessStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.GetAwsOrganizationsAccessStatusResponse
  ): zio.aws.servicecatalog.model.GetAwsOrganizationsAccessStatusResponse.ReadOnly =
    new Wrapper(impl)
}
