package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class DescribePortfolioSharesResponse(
    nextPageToken: Option[PageToken] = None,
    portfolioShareDetails: Option[
      Iterable[zio.aws.servicecatalog.model.PortfolioShareDetail]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesResponse = {
    import DescribePortfolioSharesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesResponse
      .builder()
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .optionallyWith(
        portfolioShareDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portfolioShareDetails)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribePortfolioSharesResponse.ReadOnly =
    zio.aws.servicecatalog.model.DescribePortfolioSharesResponse
      .wrap(buildAwsValue())
}
object DescribePortfolioSharesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DescribePortfolioSharesResponse =
      zio.aws.servicecatalog.model.DescribePortfolioSharesResponse(
        nextPageToken.map(value => value),
        portfolioShareDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextPageToken: Option[PageToken]
    def portfolioShareDetails: Option[
      List[zio.aws.servicecatalog.model.PortfolioShareDetail.ReadOnly]
    ]
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
    def getPortfolioShareDetails: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.PortfolioShareDetail.ReadOnly
    ]] =
      AwsError.unwrapOptionField("portfolioShareDetails", portfolioShareDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesResponse
  ) extends zio.aws.servicecatalog.model.DescribePortfolioSharesResponse.ReadOnly {
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
    override val portfolioShareDetails: Option[
      List[zio.aws.servicecatalog.model.PortfolioShareDetail.ReadOnly]
    ] = scala
      .Option(impl.portfolioShareDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.PortfolioShareDetail.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesResponse
  ): zio.aws.servicecatalog.model.DescribePortfolioSharesResponse.ReadOnly =
    new Wrapper(impl)
}
