package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{Id, AcceptLanguage}
import scala.jdk.CollectionConverters._
final case class DeleteProvisioningArtifactRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    productId: Id,
    provisioningArtifactId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DeleteProvisioningArtifactRequest = {
    import DeleteProvisioningArtifactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DeleteProvisioningArtifactRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .productId(Id.unwrap(productId): java.lang.String)
      .provisioningArtifactId(
        Id.unwrap(provisioningArtifactId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DeleteProvisioningArtifactRequest.ReadOnly =
    zio.aws.servicecatalog.model.DeleteProvisioningArtifactRequest
      .wrap(buildAwsValue())
}
object DeleteProvisioningArtifactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DeleteProvisioningArtifactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.DeleteProvisioningArtifactRequest =
      zio.aws.servicecatalog.model.DeleteProvisioningArtifactRequest(
        acceptLanguage.map(value => value),
        productId,
        provisioningArtifactId
      )
    def acceptLanguage: Option[AcceptLanguage]
    def productId: Id
    def provisioningArtifactId: Id
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getProductId: ZIO[Any, Nothing, Id] = ZIO.succeed(productId)
    def getProvisioningArtifactId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(provisioningArtifactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DeleteProvisioningArtifactRequest
  ) extends zio.aws.servicecatalog.model.DeleteProvisioningArtifactRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val productId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.productId())
    override val provisioningArtifactId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.provisioningArtifactId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DeleteProvisioningArtifactRequest
  ): zio.aws.servicecatalog.model.DeleteProvisioningArtifactRequest.ReadOnly =
    new Wrapper(impl)
}
