package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{AcceptLanguage, Id}
import scala.jdk.CollectionConverters._
final case class AssociateServiceActionWithProvisioningArtifactRequest(
    productId: Id,
    provisioningArtifactId: Id,
    serviceActionId: Id,
    acceptLanguage: Option[AcceptLanguage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactRequest = {
    import AssociateServiceActionWithProvisioningArtifactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactRequest
      .builder()
      .productId(Id.unwrap(productId): java.lang.String)
      .provisioningArtifactId(
        Id.unwrap(provisioningArtifactId): java.lang.String
      )
      .serviceActionId(Id.unwrap(serviceActionId): java.lang.String)
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactRequest.ReadOnly =
    zio.aws.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactRequest
      .wrap(buildAwsValue())
}
object AssociateServiceActionWithProvisioningArtifactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactRequest =
      zio.aws.servicecatalog.model
        .AssociateServiceActionWithProvisioningArtifactRequest(
          productId,
          provisioningArtifactId,
          serviceActionId,
          acceptLanguage.map(value => value)
        )
    def productId: Id
    def provisioningArtifactId: Id
    def serviceActionId: Id
    def acceptLanguage: Option[AcceptLanguage]
    def getProductId: ZIO[Any, Nothing, Id] = ZIO.succeed(productId)
    def getProvisioningArtifactId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(provisioningArtifactId)
    def getServiceActionId: ZIO[Any, Nothing, Id] = ZIO.succeed(serviceActionId)
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactRequest
  ) extends zio.aws.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactRequest.ReadOnly {
    override val productId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.productId())
    override val provisioningArtifactId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.provisioningArtifactId())
    override val serviceActionId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.serviceActionId())
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactRequest
  ): zio.aws.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactRequest.ReadOnly =
    new Wrapper(impl)
}
