package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  PrincipalARN,
  Id,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class AssociatePrincipalWithPortfolioRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    portfolioId: Id,
    principalARN: PrincipalARN,
    principalType: zio.aws.servicecatalog.model.PrincipalType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.AssociatePrincipalWithPortfolioRequest = {
    import AssociatePrincipalWithPortfolioRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.AssociatePrincipalWithPortfolioRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .portfolioId(Id.unwrap(portfolioId): java.lang.String)
      .principalARN(PrincipalARN.unwrap(principalARN): java.lang.String)
      .principalType(principalType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.AssociatePrincipalWithPortfolioRequest.ReadOnly =
    zio.aws.servicecatalog.model.AssociatePrincipalWithPortfolioRequest
      .wrap(buildAwsValue())
}
object AssociatePrincipalWithPortfolioRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.AssociatePrincipalWithPortfolioRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.AssociatePrincipalWithPortfolioRequest =
      zio.aws.servicecatalog.model.AssociatePrincipalWithPortfolioRequest(
        acceptLanguage.map(value => value),
        portfolioId,
        principalARN,
        principalType
      )
    def acceptLanguage: Option[AcceptLanguage]
    def portfolioId: Id
    def principalARN: PrincipalARN
    def principalType: zio.aws.servicecatalog.model.PrincipalType
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getPortfolioId: ZIO[Any, Nothing, Id] = ZIO.succeed(portfolioId)
    def getPrincipalARN: ZIO[Any, Nothing, PrincipalARN] =
      ZIO.succeed(principalARN)
    def getPrincipalType
        : ZIO[Any, Nothing, zio.aws.servicecatalog.model.PrincipalType] =
      ZIO.succeed(principalType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.AssociatePrincipalWithPortfolioRequest
  ) extends zio.aws.servicecatalog.model.AssociatePrincipalWithPortfolioRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val portfolioId: Id =
      zio.aws.servicecatalog.model.primitives.Id(impl.portfolioId())
    override val principalARN: PrincipalARN =
      zio.aws.servicecatalog.model.primitives.PrincipalARN(impl.principalARN())
    override val principalType: zio.aws.servicecatalog.model.PrincipalType =
      zio.aws.servicecatalog.model.PrincipalType.wrap(impl.principalType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.AssociatePrincipalWithPortfolioRequest
  ): zio.aws.servicecatalog.model.AssociatePrincipalWithPortfolioRequest.ReadOnly =
    new Wrapper(impl)
}
