package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  AcceptLanguage,
  RetainPhysicalResources,
  IgnoreErrors,
  IdempotencyToken,
  ProvisionedProductNameOrArn,
  Id
}
import scala.jdk.CollectionConverters._
final case class TerminateProvisionedProductRequest(
    provisionedProductName: Option[ProvisionedProductNameOrArn] = None,
    provisionedProductId: Option[Id] = None,
    terminateToken: IdempotencyToken,
    ignoreErrors: Option[IgnoreErrors] = None,
    acceptLanguage: Option[AcceptLanguage] = None,
    retainPhysicalResources: Option[RetainPhysicalResources] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.TerminateProvisionedProductRequest = {
    import TerminateProvisionedProductRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.TerminateProvisionedProductRequest
      .builder()
      .optionallyWith(
        provisionedProductName.map(value =>
          ProvisionedProductNameOrArn.unwrap(value): java.lang.String
        )
      )(_.provisionedProductName)
      .optionallyWith(
        provisionedProductId.map(value => Id.unwrap(value): java.lang.String)
      )(_.provisionedProductId)
      .terminateToken(IdempotencyToken.unwrap(terminateToken): java.lang.String)
      .optionallyWith(
        ignoreErrors.map(value => IgnoreErrors.unwrap(value): java.lang.Boolean)
      )(_.ignoreErrors)
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .optionallyWith(
        retainPhysicalResources.map(value =>
          RetainPhysicalResources.unwrap(value): java.lang.Boolean
        )
      )(_.retainPhysicalResources)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.TerminateProvisionedProductRequest.ReadOnly =
    zio.aws.servicecatalog.model.TerminateProvisionedProductRequest
      .wrap(buildAwsValue())
}
object TerminateProvisionedProductRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.TerminateProvisionedProductRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.TerminateProvisionedProductRequest =
      zio.aws.servicecatalog.model.TerminateProvisionedProductRequest(
        provisionedProductName.map(value => value),
        provisionedProductId.map(value => value),
        terminateToken,
        ignoreErrors.map(value => value),
        acceptLanguage.map(value => value),
        retainPhysicalResources.map(value => value)
      )
    def provisionedProductName: Option[ProvisionedProductNameOrArn]
    def provisionedProductId: Option[Id]
    def terminateToken: IdempotencyToken
    def ignoreErrors: Option[IgnoreErrors]
    def acceptLanguage: Option[AcceptLanguage]
    def retainPhysicalResources: Option[RetainPhysicalResources]
    def getProvisionedProductName
        : ZIO[Any, AwsError, ProvisionedProductNameOrArn] = AwsError
      .unwrapOptionField("provisionedProductName", provisionedProductName)
    def getProvisionedProductId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("provisionedProductId", provisionedProductId)
    def getTerminateToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(terminateToken)
    def getIgnoreErrors: ZIO[Any, AwsError, IgnoreErrors] =
      AwsError.unwrapOptionField("ignoreErrors", ignoreErrors)
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getRetainPhysicalResources
        : ZIO[Any, AwsError, RetainPhysicalResources] = AwsError
      .unwrapOptionField("retainPhysicalResources", retainPhysicalResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.TerminateProvisionedProductRequest
  ) extends zio.aws.servicecatalog.model.TerminateProvisionedProductRequest.ReadOnly {
    override val provisionedProductName: Option[ProvisionedProductNameOrArn] =
      scala
        .Option(impl.provisionedProductName())
        .map(value =>
          zio.aws.servicecatalog.model.primitives
            .ProvisionedProductNameOrArn(value)
        )
    override val provisionedProductId: Option[Id] = scala
      .Option(impl.provisionedProductId())
      .map(value => zio.aws.servicecatalog.model.primitives.Id(value))
    override val terminateToken: IdempotencyToken =
      zio.aws.servicecatalog.model.primitives
        .IdempotencyToken(impl.terminateToken())
    override val ignoreErrors: Option[IgnoreErrors] = scala
      .Option(impl.ignoreErrors())
      .map(value => zio.aws.servicecatalog.model.primitives.IgnoreErrors(value))
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val retainPhysicalResources: Option[RetainPhysicalResources] =
      scala
        .Option(impl.retainPhysicalResources())
        .map(value =>
          zio.aws.servicecatalog.model.primitives.RetainPhysicalResources(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.TerminateProvisionedProductRequest
  ): zio.aws.servicecatalog.model.TerminateProvisionedProductRequest.ReadOnly =
    new Wrapper(impl)
}
