package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{Region, AccountId}
import scala.jdk.CollectionConverters._
final case class StackInstance(
    account: Option[AccountId] = None,
    region: Option[Region] = None,
    stackInstanceStatus: Option[
      zio.aws.servicecatalog.model.StackInstanceStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.StackInstance = {
    import StackInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.StackInstance
      .builder()
      .optionallyWith(
        account.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.account)
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(stackInstanceStatus.map(value => value.unwrap))(
        _.stackInstanceStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.StackInstance.ReadOnly =
    zio.aws.servicecatalog.model.StackInstance.wrap(buildAwsValue())
}
object StackInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.StackInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.StackInstance =
      zio.aws.servicecatalog.model.StackInstance(
        account.map(value => value),
        region.map(value => value),
        stackInstanceStatus.map(value => value)
      )
    def account: Option[AccountId]
    def region: Option[Region]
    def stackInstanceStatus
        : Option[zio.aws.servicecatalog.model.StackInstanceStatus]
    def getAccount: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("account", account)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
    def getStackInstanceStatus
        : ZIO[Any, AwsError, zio.aws.servicecatalog.model.StackInstanceStatus] =
      AwsError.unwrapOptionField("stackInstanceStatus", stackInstanceStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.StackInstance
  ) extends zio.aws.servicecatalog.model.StackInstance.ReadOnly {
    override val account: Option[AccountId] = scala
      .Option(impl.account())
      .map(value => zio.aws.servicecatalog.model.primitives.AccountId(value))
    override val region: Option[Region] = scala
      .Option(impl.region())
      .map(value => zio.aws.servicecatalog.model.primitives.Region(value))
    override val stackInstanceStatus
        : Option[zio.aws.servicecatalog.model.StackInstanceStatus] = scala
      .Option(impl.stackInstanceStatus())
      .map(value =>
        zio.aws.servicecatalog.model.StackInstanceStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.StackInstance
  ): zio.aws.servicecatalog.model.StackInstance.ReadOnly = new Wrapper(impl)
}
