package zio.aws.servicecatalog.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  StackSetMaxConcurrencyCount,
  AccountId,
  StackSetFailureToleranceCount,
  Region,
  StackSetFailureTolerancePercentage,
  StackSetMaxConcurrencyPercentage
}
import scala.jdk.CollectionConverters._
final case class ProvisioningPreferences(
    stackSetAccounts: Option[Iterable[AccountId]] = None,
    stackSetRegions: Option[Iterable[Region]] = None,
    stackSetFailureToleranceCount: Option[StackSetFailureToleranceCount] = None,
    stackSetFailureTolerancePercentage: Option[
      StackSetFailureTolerancePercentage
    ] = None,
    stackSetMaxConcurrencyCount: Option[StackSetMaxConcurrencyCount] = None,
    stackSetMaxConcurrencyPercentage: Option[StackSetMaxConcurrencyPercentage] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisioningPreferences = {
    import ProvisioningPreferences.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningPreferences
      .builder()
      .optionallyWith(
        stackSetAccounts.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.stackSetAccounts)
      .optionallyWith(
        stackSetRegions.map(value =>
          value.map { item =>
            Region.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.stackSetRegions)
      .optionallyWith(
        stackSetFailureToleranceCount.map(value =>
          StackSetFailureToleranceCount.unwrap(value): Integer
        )
      )(_.stackSetFailureToleranceCount)
      .optionallyWith(
        stackSetFailureTolerancePercentage.map(value =>
          StackSetFailureTolerancePercentage.unwrap(value): Integer
        )
      )(_.stackSetFailureTolerancePercentage)
      .optionallyWith(
        stackSetMaxConcurrencyCount.map(value =>
          StackSetMaxConcurrencyCount.unwrap(value): Integer
        )
      )(_.stackSetMaxConcurrencyCount)
      .optionallyWith(
        stackSetMaxConcurrencyPercentage.map(value =>
          StackSetMaxConcurrencyPercentage.unwrap(value): Integer
        )
      )(_.stackSetMaxConcurrencyPercentage)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ProvisioningPreferences.ReadOnly =
    zio.aws.servicecatalog.model.ProvisioningPreferences.wrap(buildAwsValue())
}
object ProvisioningPreferences {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisioningPreferences
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProvisioningPreferences =
      zio.aws.servicecatalog.model.ProvisioningPreferences(
        stackSetAccounts.map(value => value),
        stackSetRegions.map(value => value),
        stackSetFailureToleranceCount.map(value => value),
        stackSetFailureTolerancePercentage.map(value => value),
        stackSetMaxConcurrencyCount.map(value => value),
        stackSetMaxConcurrencyPercentage.map(value => value)
      )
    def stackSetAccounts: Option[List[AccountId]]
    def stackSetRegions: Option[List[Region]]
    def stackSetFailureToleranceCount: Option[StackSetFailureToleranceCount]
    def stackSetFailureTolerancePercentage
        : Option[StackSetFailureTolerancePercentage]
    def stackSetMaxConcurrencyCount: Option[StackSetMaxConcurrencyCount]
    def stackSetMaxConcurrencyPercentage
        : Option[StackSetMaxConcurrencyPercentage]
    def getStackSetAccounts: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("stackSetAccounts", stackSetAccounts)
    def getStackSetRegions: ZIO[Any, AwsError, List[Region]] =
      AwsError.unwrapOptionField("stackSetRegions", stackSetRegions)
    def getStackSetFailureToleranceCount
        : ZIO[Any, AwsError, StackSetFailureToleranceCount] =
      AwsError.unwrapOptionField(
        "stackSetFailureToleranceCount",
        stackSetFailureToleranceCount
      )
    def getStackSetFailureTolerancePercentage
        : ZIO[Any, AwsError, StackSetFailureTolerancePercentage] =
      AwsError.unwrapOptionField(
        "stackSetFailureTolerancePercentage",
        stackSetFailureTolerancePercentage
      )
    def getStackSetMaxConcurrencyCount
        : ZIO[Any, AwsError, StackSetMaxConcurrencyCount] =
      AwsError.unwrapOptionField(
        "stackSetMaxConcurrencyCount",
        stackSetMaxConcurrencyCount
      )
    def getStackSetMaxConcurrencyPercentage
        : ZIO[Any, AwsError, StackSetMaxConcurrencyPercentage] =
      AwsError.unwrapOptionField(
        "stackSetMaxConcurrencyPercentage",
        stackSetMaxConcurrencyPercentage
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningPreferences
  ) extends zio.aws.servicecatalog.model.ProvisioningPreferences.ReadOnly {
    override val stackSetAccounts: Option[List[AccountId]] = scala
      .Option(impl.stackSetAccounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.primitives.AccountId(item)
        }.toList
      )
    override val stackSetRegions: Option[List[Region]] = scala
      .Option(impl.stackSetRegions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.primitives.Region(item)
        }.toList
      )
    override val stackSetFailureToleranceCount
        : Option[StackSetFailureToleranceCount] = scala
      .Option(impl.stackSetFailureToleranceCount())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .StackSetFailureToleranceCount(value)
      )
    override val stackSetFailureTolerancePercentage
        : Option[StackSetFailureTolerancePercentage] = scala
      .Option(impl.stackSetFailureTolerancePercentage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .StackSetFailureTolerancePercentage(value)
      )
    override val stackSetMaxConcurrencyCount
        : Option[StackSetMaxConcurrencyCount] = scala
      .Option(impl.stackSetMaxConcurrencyCount())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .StackSetMaxConcurrencyCount(value)
      )
    override val stackSetMaxConcurrencyPercentage
        : Option[StackSetMaxConcurrencyPercentage] = scala
      .Option(impl.stackSetMaxConcurrencyPercentage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives
          .StackSetMaxConcurrencyPercentage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisioningPreferences
  ): zio.aws.servicecatalog.model.ProvisioningPreferences.ReadOnly =
    new Wrapper(impl)
}
