package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ListResourcesForTagOptionResponse(
    resourceDetails: Option[
      Iterable[zio.aws.servicecatalog.model.ResourceDetail]
    ] = None,
    pageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionResponse = {
    import ListResourcesForTagOptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionResponse
      .builder()
      .optionallyWith(
        resourceDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceDetails)
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListResourcesForTagOptionResponse.ReadOnly =
    zio.aws.servicecatalog.model.ListResourcesForTagOptionResponse
      .wrap(buildAwsValue())
}
object ListResourcesForTagOptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListResourcesForTagOptionResponse =
      zio.aws.servicecatalog.model.ListResourcesForTagOptionResponse(
        resourceDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pageToken.map(value => value)
      )
    def resourceDetails
        : Option[List[zio.aws.servicecatalog.model.ResourceDetail.ReadOnly]]
    def pageToken: Option[PageToken]
    def getResourceDetails: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ResourceDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceDetails", resourceDetails)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionResponse
  ) extends zio.aws.servicecatalog.model.ListResourcesForTagOptionResponse.ReadOnly {
    override val resourceDetails
        : Option[List[zio.aws.servicecatalog.model.ResourceDetail.ReadOnly]] =
      scala
        .Option(impl.resourceDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.ResourceDetail.wrap(item)
          }.toList
        )
    override val pageToken: Option[PageToken] = scala
      .Option(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListResourcesForTagOptionResponse
  ): zio.aws.servicecatalog.model.ListResourcesForTagOptionResponse.ReadOnly =
    new Wrapper(impl)
}
