package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  SearchFilterValue,
  SearchFilterKey
}
import scala.jdk.CollectionConverters._
final case class ListRecordHistorySearchFilter(
    key: Option[SearchFilterKey] = None,
    value: Option[SearchFilterValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListRecordHistorySearchFilter = {
    import ListRecordHistorySearchFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListRecordHistorySearchFilter
      .builder()
      .optionallyWith(
        key.map(value => SearchFilterKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => SearchFilterValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListRecordHistorySearchFilter.ReadOnly =
    zio.aws.servicecatalog.model.ListRecordHistorySearchFilter
      .wrap(buildAwsValue())
}
object ListRecordHistorySearchFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListRecordHistorySearchFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ListRecordHistorySearchFilter =
      zio.aws.servicecatalog.model.ListRecordHistorySearchFilter(
        key.map(value => value),
        value.map(value => value)
      )
    def key: Option[SearchFilterKey]
    def value: Option[SearchFilterValue]
    def getKey: ZIO[Any, AwsError, SearchFilterKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, SearchFilterValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListRecordHistorySearchFilter
  ) extends zio.aws.servicecatalog.model.ListRecordHistorySearchFilter.ReadOnly {
    override val key: Option[SearchFilterKey] = scala
      .Option(impl.key())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.SearchFilterKey(value)
      )
    override val value: Option[SearchFilterValue] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.SearchFilterValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListRecordHistorySearchFilter
  ): zio.aws.servicecatalog.model.ListRecordHistorySearchFilter.ReadOnly =
    new Wrapper(impl)
}
