package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class DescribeRecordResponse(
    recordDetail: Option[zio.aws.servicecatalog.model.RecordDetail] = None,
    recordOutputs: Option[Iterable[zio.aws.servicecatalog.model.RecordOutput]] =
      None,
    nextPageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeRecordResponse = {
    import DescribeRecordResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeRecordResponse
      .builder()
      .optionallyWith(recordDetail.map(value => value.buildAwsValue()))(
        _.recordDetail
      )
      .optionallyWith(
        recordOutputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recordOutputs)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.DescribeRecordResponse.ReadOnly =
    zio.aws.servicecatalog.model.DescribeRecordResponse.wrap(buildAwsValue())
}
object DescribeRecordResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeRecordResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.DescribeRecordResponse =
      zio.aws.servicecatalog.model.DescribeRecordResponse(
        recordDetail.map(value => value.asEditable),
        recordOutputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def recordDetail: Option[zio.aws.servicecatalog.model.RecordDetail.ReadOnly]
    def recordOutputs
        : Option[List[zio.aws.servicecatalog.model.RecordOutput.ReadOnly]]
    def nextPageToken: Option[PageToken]
    def getRecordDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.RecordDetail.ReadOnly
    ] = AwsError.unwrapOptionField("recordDetail", recordDetail)
    def getRecordOutputs: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.RecordOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("recordOutputs", recordOutputs)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeRecordResponse
  ) extends zio.aws.servicecatalog.model.DescribeRecordResponse.ReadOnly {
    override val recordDetail
        : Option[zio.aws.servicecatalog.model.RecordDetail.ReadOnly] = scala
      .Option(impl.recordDetail())
      .map(value => zio.aws.servicecatalog.model.RecordDetail.wrap(value))
    override val recordOutputs
        : Option[List[zio.aws.servicecatalog.model.RecordOutput.ReadOnly]] =
      scala
        .Option(impl.recordOutputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.servicecatalog.model.RecordOutput.wrap(item)
          }.toList
        )
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeRecordResponse
  ): zio.aws.servicecatalog.model.DescribeRecordResponse.ReadOnly = new Wrapper(
    impl
  )
}
