package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{Id, AcceptLanguage}
import scala.jdk.CollectionConverters._
final case class DescribeProductViewRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    id: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewRequest = {
    import DescribeProductViewRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .id(Id.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.DescribeProductViewRequest.ReadOnly =
    zio.aws.servicecatalog.model.DescribeProductViewRequest
      .wrap(buildAwsValue())
}
object DescribeProductViewRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.DescribeProductViewRequest =
      zio.aws.servicecatalog.model
        .DescribeProductViewRequest(acceptLanguage.map(value => value), id)
    def acceptLanguage: Option[AcceptLanguage]
    def id: Id
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getId: ZIO[Any, Nothing, Id] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewRequest
  ) extends zio.aws.servicecatalog.model.DescribeProductViewRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val id: Id = zio.aws.servicecatalog.model.primitives.Id(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.DescribeProductViewRequest
  ): zio.aws.servicecatalog.model.DescribeProductViewRequest.ReadOnly =
    new Wrapper(impl)
}
