package zio.aws.servicecatalog.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{PageToken, TotalResultsCount}
import scala.jdk.CollectionConverters._
final case class SearchProvisionedProductsResponse(
    provisionedProducts: Option[
      Iterable[zio.aws.servicecatalog.model.ProvisionedProductAttribute]
    ] = None,
    totalResultsCount: Option[TotalResultsCount] = None,
    nextPageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse = {
    import SearchProvisionedProductsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse
      .builder()
      .optionallyWith(
        provisionedProducts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisionedProducts)
      .optionallyWith(
        totalResultsCount.map(value => TotalResultsCount.unwrap(value): Integer)
      )(_.totalResultsCount)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.SearchProvisionedProductsResponse.ReadOnly =
    zio.aws.servicecatalog.model.SearchProvisionedProductsResponse
      .wrap(buildAwsValue())
}
object SearchProvisionedProductsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.SearchProvisionedProductsResponse =
      zio.aws.servicecatalog.model.SearchProvisionedProductsResponse(
        provisionedProducts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        totalResultsCount.map(value => value),
        nextPageToken.map(value => value)
      )
    def provisionedProducts: Option[
      List[zio.aws.servicecatalog.model.ProvisionedProductAttribute.ReadOnly]
    ]
    def totalResultsCount: Option[TotalResultsCount]
    def nextPageToken: Option[PageToken]
    def getProvisionedProducts: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ProvisionedProductAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("provisionedProducts", provisionedProducts)
    def getTotalResultsCount: ZIO[Any, AwsError, TotalResultsCount] =
      AwsError.unwrapOptionField("totalResultsCount", totalResultsCount)
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse
  ) extends zio.aws.servicecatalog.model.SearchProvisionedProductsResponse.ReadOnly {
    override val provisionedProducts: Option[
      List[zio.aws.servicecatalog.model.ProvisionedProductAttribute.ReadOnly]
    ] = scala
      .Option(impl.provisionedProducts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ProvisionedProductAttribute.wrap(item)
        }.toList
      )
    override val totalResultsCount: Option[TotalResultsCount] = scala
      .Option(impl.totalResultsCount())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.TotalResultsCount(value)
      )
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsResponse
  ): zio.aws.servicecatalog.model.SearchProvisionedProductsResponse.ReadOnly =
    new Wrapper(impl)
}
