package zio.aws.servicecatalog.model
import scala.jdk.CollectionConverters._
sealed trait RecordStatus {
  def unwrap: software.amazon.awssdk.services.servicecatalog.model.RecordStatus
}
object RecordStatus {
  def wrap(
      value: software.amazon.awssdk.services.servicecatalog.model.RecordStatus
  ): zio.aws.servicecatalog.model.RecordStatus = value match {
    case software.amazon.awssdk.services.servicecatalog.model.RecordStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.servicecatalog.model.RecordStatus.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.servicecatalog.model.RecordStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.servicecatalog.model.RecordStatus.IN_PROGRESS_IN_ERROR =>
      val r = IN_PROGRESS_IN_ERROR
      r
    case software.amazon.awssdk.services.servicecatalog.model.RecordStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.servicecatalog.model.RecordStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.servicecatalog.model.RecordStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.RecordStatus =
      software.amazon.awssdk.services.servicecatalog.model.RecordStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATED extends zio.aws.servicecatalog.model.RecordStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.RecordStatus =
      software.amazon.awssdk.services.servicecatalog.model.RecordStatus.CREATED
  }
  case object IN_PROGRESS extends zio.aws.servicecatalog.model.RecordStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.RecordStatus =
      software.amazon.awssdk.services.servicecatalog.model.RecordStatus.IN_PROGRESS
  }
  case object IN_PROGRESS_IN_ERROR
      extends zio.aws.servicecatalog.model.RecordStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.RecordStatus =
      software.amazon.awssdk.services.servicecatalog.model.RecordStatus.IN_PROGRESS_IN_ERROR
  }
  case object SUCCEEDED extends zio.aws.servicecatalog.model.RecordStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.RecordStatus =
      software.amazon.awssdk.services.servicecatalog.model.RecordStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.servicecatalog.model.RecordStatus {
    override def unwrap
        : software.amazon.awssdk.services.servicecatalog.model.RecordStatus =
      software.amazon.awssdk.services.servicecatalog.model.RecordStatus.FAILED
  }
}
