package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProvisionProductResponse(
    recordDetail: Option[zio.aws.servicecatalog.model.RecordDetail] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ProvisionProductResponse = {
    import ProvisionProductResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ProvisionProductResponse
      .builder()
      .optionallyWith(recordDetail.map(value => value.buildAwsValue()))(
        _.recordDetail
      )
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ProvisionProductResponse.ReadOnly =
    zio.aws.servicecatalog.model.ProvisionProductResponse.wrap(buildAwsValue())
}
object ProvisionProductResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ProvisionProductResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ProvisionProductResponse =
      zio.aws.servicecatalog.model
        .ProvisionProductResponse(recordDetail.map(value => value.asEditable))
    def recordDetail: Option[zio.aws.servicecatalog.model.RecordDetail.ReadOnly]
    def getRecordDetail: ZIO[
      Any,
      AwsError,
      zio.aws.servicecatalog.model.RecordDetail.ReadOnly
    ] = AwsError.unwrapOptionField("recordDetail", recordDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisionProductResponse
  ) extends zio.aws.servicecatalog.model.ProvisionProductResponse.ReadOnly {
    override val recordDetail
        : Option[zio.aws.servicecatalog.model.RecordDetail.ReadOnly] = scala
      .Option(impl.recordDetail())
      .map(value => zio.aws.servicecatalog.model.RecordDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ProvisionProductResponse
  ): zio.aws.servicecatalog.model.ProvisionProductResponse.ReadOnly =
    new Wrapper(impl)
}
