package zio.aws.servicecatalog.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.PageToken
import scala.jdk.CollectionConverters._
final case class ListProvisionedProductPlansResponse(
    provisionedProductPlans: Option[
      Iterable[zio.aws.servicecatalog.model.ProvisionedProductPlanSummary]
    ] = None,
    nextPageToken: Option[PageToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansResponse = {
    import ListProvisionedProductPlansResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansResponse
      .builder()
      .optionallyWith(
        provisionedProductPlans.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisionedProductPlans)
      .optionallyWith(
        nextPageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextPageToken)
      .build()
  }
  def asReadOnly
      : zio.aws.servicecatalog.model.ListProvisionedProductPlansResponse.ReadOnly =
    zio.aws.servicecatalog.model.ListProvisionedProductPlansResponse
      .wrap(buildAwsValue())
}
object ListProvisionedProductPlansResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.servicecatalog.model.ListProvisionedProductPlansResponse =
      zio.aws.servicecatalog.model.ListProvisionedProductPlansResponse(
        provisionedProductPlans.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def provisionedProductPlans: Option[
      List[zio.aws.servicecatalog.model.ProvisionedProductPlanSummary.ReadOnly]
    ]
    def nextPageToken: Option[PageToken]
    def getProvisionedProductPlans: ZIO[Any, AwsError, List[
      zio.aws.servicecatalog.model.ProvisionedProductPlanSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "provisionedProductPlans",
      provisionedProductPlans
    )
    def getNextPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansResponse
  ) extends zio.aws.servicecatalog.model.ListProvisionedProductPlansResponse.ReadOnly {
    override val provisionedProductPlans: Option[
      List[zio.aws.servicecatalog.model.ProvisionedProductPlanSummary.ReadOnly]
    ] = scala
      .Option(impl.provisionedProductPlans())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.servicecatalog.model.ProvisionedProductPlanSummary.wrap(item)
        }.toList
      )
    override val nextPageToken: Option[PageToken] = scala
      .Option(impl.nextPageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListProvisionedProductPlansResponse
  ): zio.aws.servicecatalog.model.ListProvisionedProductPlansResponse.ReadOnly =
    new Wrapper(impl)
}
