package zio.aws.servicecatalog.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.servicecatalog.model.primitives.{
  PageSizeMax100,
  PageToken,
  AcceptLanguage
}
import scala.jdk.CollectionConverters._
final case class ListPortfoliosRequest(
    acceptLanguage: Option[AcceptLanguage] = None,
    pageToken: Option[PageToken] = None,
    pageSize: Option[PageSizeMax100] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest = {
    import ListPortfoliosRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest
      .builder()
      .optionallyWith(
        acceptLanguage.map(value =>
          AcceptLanguage.unwrap(value): java.lang.String
        )
      )(_.acceptLanguage)
      .optionallyWith(
        pageToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.pageToken)
      .optionallyWith(
        pageSize.map(value => PageSizeMax100.unwrap(value): Integer)
      )(_.pageSize)
      .build()
  }
  def asReadOnly: zio.aws.servicecatalog.model.ListPortfoliosRequest.ReadOnly =
    zio.aws.servicecatalog.model.ListPortfoliosRequest.wrap(buildAwsValue())
}
object ListPortfoliosRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.servicecatalog.model.ListPortfoliosRequest =
      zio.aws.servicecatalog.model.ListPortfoliosRequest(
        acceptLanguage.map(value => value),
        pageToken.map(value => value),
        pageSize.map(value => value)
      )
    def acceptLanguage: Option[AcceptLanguage]
    def pageToken: Option[PageToken]
    def pageSize: Option[PageSizeMax100]
    def getAcceptLanguage: ZIO[Any, AwsError, AcceptLanguage] =
      AwsError.unwrapOptionField("acceptLanguage", acceptLanguage)
    def getPageToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("pageToken", pageToken)
    def getPageSize: ZIO[Any, AwsError, PageSizeMax100] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest
  ) extends zio.aws.servicecatalog.model.ListPortfoliosRequest.ReadOnly {
    override val acceptLanguage: Option[AcceptLanguage] = scala
      .Option(impl.acceptLanguage())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.AcceptLanguage(value)
      )
    override val pageToken: Option[PageToken] = scala
      .Option(impl.pageToken())
      .map(value => zio.aws.servicecatalog.model.primitives.PageToken(value))
    override val pageSize: Option[PageSizeMax100] = scala
      .Option(impl.pageSize())
      .map(value =>
        zio.aws.servicecatalog.model.primitives.PageSizeMax100(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest
  ): zio.aws.servicecatalog.model.ListPortfoliosRequest.ReadOnly = new Wrapper(
    impl
  )
}
